// **************************************************************************
// * File:   Union_1.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Class to represent storage that can hold any of a union of 	*
// *         different types. Currently implemented as a universal holder.	*
// **************************************************************************

#if !defined(_h_Main_Union)
#define _h_Main_Union 1

//----------------
// Class '_eUnion'
//----------------

class _eUnion : public _eBaseHandle
{
  public :

	//-----------------------------------------------------------
	// Constructors
	// Note: we allow the system to generate the copy constructor
	//       and the copy assignment operator.
	//-----------------------------------------------------------

	// Default constructor (also used to construct a union with value "null")
	_eUnion() : _eBaseHandle()
	{
	}

	// Build a union from a pointer
	explicit _eUnion(const _eAny *y) : _eBaseHandle(y)
	{
	}

	//-------------------------------
	// Concrrete member functionality
	//-------------------------------

	// Assignment from a pointer
    _eUnion& operator=(const _eAny* h)
	{
		assign(h);
		return *this;
	}

	const _eAny& operator*() const
	{
		checkNotNull();
		return *(operator->());
	}

	const _eAny* operator->() const
	{
		checkNotNull();
		return static_cast<const _eAny*>(Object);
	}

	// Return a pointer to the object
	const _eAny* Ptr() const
	{
		return static_cast<const _eAny*>(Object);
	}

	// Return a pointer to the object, preparing to change it
	_eAny* ChangePtr()
	{
		Unbind();
		return static_cast<_eAny*>(Object);
	}
	//
	_eUnion& CheckNotNull()
	{
		checkUnionNotNull();
		return *this;
	}
	//
	_eUnion& CheckIsNull()
	{
		checkUnionIsNull();
		return *this;
	}
	//
	const _eUnion& CheckNotNull() const
	{
		checkUnionNotNull();
		return *this;
	}
	//
	const _eUnion& CheckIsNull() const
	{
		checkUnionIsNull();
		return *this;
	}

	//------------------------------------------------------------------------------------------------------------------
	// Routines to implement persistant storage of union's ...
	// Note that the code is placed here and not in the base class (_eBaseHandle) because we need to access members of
	// the storage-stream, and because it is not a template class and appears in ErtSys.hpp before _eStorageStream, it
	// would not be possible to compile the base class. We can get away with putting it here however, since this class
	// appears _after_ the full definition of storage-stream ...
	//------------------------------------------------------------------------------------------------------------------

	//??? This schema would not be required to do anything if we could implement the commented-out code in ClassTypeDecls.pd
	//    for storing unions. For now, it will do the job of invoking the storage stream schema 'storeUnion(..)' ...
	void _astore(_eStoreStream* stream) const;

	// This schema will be called for filling template classes instantiated with universal unions. For objects of
	// universal union type this call could be optimised out by calling _afillUnion directly, however this is not
	// implemented at present.
	void _afill(_eFillStream* stream);

	// This store schema actually stores the held object in the stream. It is called from the _astoreUnion(..) schema in
	// the storage stream class ...
	void _adoStore(_eStoreStream* stream) const;

	// Function to return an instantiable type-info object that describes the storable type held inside this union ...
	_eHndl < _eInstblTypeInfo > _aGetMyTypeInfo() const;

	// Function to return an instantiable type-info object that describes a universal union (used for matching purposs only,
	// since this function will only get called when generating a full type description of a template instantiation with a
	// universal union) ...
	static _eHndl<_eInstblTypeInfo> _aMyTypeInfo();
};

// Global function to support toString in template methods
inline _rstring _ltoString(_eUnion arg)
{
	return (arg.Ptr() == NULL ? _mString("null") : arg -> toString());
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
