// **************************************************************************
// * File:   Handle.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   The handle semantics for 'Perfect'								*
// **************************************************************************

#if !defined(_H_EHANDLE)
#define _H_EHANDLE 1

// We use '_eHndlUnionVoid' when Object may be null for added clarity, but in fact the class is just _eHndl
#define _eHndlUnionVoid _eHndl

template <class X>
class _eHndl : public _eBaseHandle
{
  public :

	// Default constructor, creates a 'null handle'
    _eHndl() : _eBaseHandle()
	{
	}

	// Build a handle from an object pointer
	explicit _eHndl(const X* xptr): _eBaseHandle(xptr)
	{
	}

	// Note: we allow the system to generate the copy constructor and the copy assignment operator

	// Assign a handle from an object pointer
    _eHndl<X >& operator=(const X* h)
	{
		assign(h);
		return *this;
	}

	// Equality operator, optimised version for comparing with a handle of the same type
    _eBool operator==(const _eHndl<X >& h) const
	{
		return 	   Object == h.Object
				|| (   Object != NULL
					&& h.Object != NULL
					&& (*static_cast<const X*>(Object)) == static_cast<const X*>(h.Object)
				   );
	}

	// Dereferencing operator, giving access to the object in a const way
    const X& operator*() const
	{
		return *(operator->());
	}

    // Used for getting at the object to get at members in a 'const' way.
    const X* operator->() const
	{
		checkNotNull();
		return static_cast<const X*>(Object);
	}

    // Used for getting at the object to change it.
    X& Change()
	{
		Unbind();
		return *static_cast<X*> (Object);
	}

	// Return a pointer to the object (possibly null)
	const X* Ptr() const
	{
		return static_cast<const X*> (Object);
	}

	// Return a changeable pointer to the object (possibly null)
	X* ChangePtr()
	{
		Unbind();
		return static_cast<X*> (Object);
	}

	//--------------------
	// Null check routines
	//--------------------

	_eHndl<X >& CheckNotNull()
	{
		checkUnionNotNull();
		return *this;
	}

	const _eHndl<X >& CheckNotNull() const
	{
		checkUnionNotNull();
		return *this;
	}

	_eHndl<X >& CheckIsNull()
	{
		checkUnionIsNull();
		return *this;
	}

	const _eHndl<X >& CheckIsNull() const
	{
		checkUnionIsNull();
		return *this;
	}

	// We define 'fill' here - 'store' is inherited from _eBaseHandle
	void _afill(_eFillStream* stream);

	static _eHndl<_eInstblTypeInfo> _aMyTypeInfo()
	{
		return X :: _aMyTypeInfo();
	}

};

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
