// Base class for representing a set as a bitmap
// D. Crocker, 3 March 2004
// Used for representing sets of enumeration types

// Traits class to help us specialise bitsets of varous sizes
template <int N> class _eBitSetTraits
{
	static const _eComplexValue :: _eEnum cvCode;
}

template <> class _eBitSetTraits<8>
{
	typedef _eUint8 BitsType;
}
template <> _eComplexValue :: _eEnum _eBitSetTraits<8> :: cvCode = _eComplexValue :: CV_BITS8;

template <> class _eBitSetTraits<16>
{
	typedef _eUint16 BitsType;
}
template <> _eComplexValue :: _eEnum _eBitSetTraits<16> :: cvCode = _eComplexValue :: CV_BITS16;

template <> class _eBitSetTraits<32>
{
	typedef _eUint32 BitsType;
}
template <> _eComplexValue :: _eEnum _eBitSetTraits<32> :: cvCode = _eComplexValue :: CV_BITS32;

template <> class _eBitSetTraits<64>
{
	typedef _eUint64 BitsType;
}
template <> _eComplexValue :: _eEnum _eBitSetTraits<64> :: cvCode = _eComplexValue :: CV_BITS64;


// Bitset class, can be instantiated with N = 8, 16, 32 or 64
template <class X, int N> class _eBitSet
{
  private:
	typename _eBitSetTraits<N>::BitsType bits;

	explicit _eBitSet(typename _eBitSetTraits<N>::BitsType b) : bits(b) {}

  public:
	bool _oIn(X arg) const
	{
		return (bits & (static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<unsigned int>(arg)));
	}

	_eBitSet< X, N > _oPlusPlus(const _eBitSet< X, N > arg) const
	{
		return _eBitSet< X >(bits | arg.bits);
	}

    void _osPlusPlus (const _eBitSet< X, N > arg)
	{
		bits |= arg.bits;
	}

	_eBitSet< X, N > _oStarStar(const _eBitSet< X, N > arg) const
	{
		return _eBitSet< X >(bits & arg.bits);
	}

    void _osStarStar(const _eBitSet< X, N > arg)
	{
		bits &= arg.bits;
	}

	_eBitSet< X, N > _oMinusMinus(const _eBitSet< X, N > arg) const
	{
		return _eBitSet< X, N >(bits & ~(arg.bits));
	}

    void _osMinusMinus(const _eBitSet< X, N > arg)
	{
		bits &= (~arg.bits);
	}

	_eBool _oHashHash(const _eBitSet< X, N > arg) const
	{
		return !(bits & arg.bits);
	}

	_eBool empty() const
	{
		return bits == static_cast<typename _eBitSetTraits<N>::BitsType>(0);
	}

	T _rmin()
	{
		_mFunction(min)
		return static_cast<T>(_eEscherRuntime :: minBit(bits));
	}

	T _rmax()
	{
		_mFunction(max)
		return static_cast<T>(_eEscherRuntime :: maxBit(bits));
	}

	_eInt _oHash() const
	{
		return _eEscherRuntime :: countBits(bits);
	}

	_eBool _oLessLessEq(const _eBitSet< X, N > arg) const
	{
		return !(bits & ~(arg.bits));
	}

	_eBool _oLessLess(const _eBitSet< X, N > arg) const
	{
		return !(bits & ~(arg.bits)) && (bits != arg.bits);
	}

	_eBool operator ==(const _eBitSet< X, N > arg) const
	{
		return bits == arg.bits;
	}

	_eBool operator < (const _eBitSet< X, N > arg) const
	{
	    ??? return (:: _oRank ((* this), arg) == _eRank :: below);
	}

	_eBool operator <= (const _eBitSet< X, N > arg) const
	{
	    ??? return (!(:: _oRank ((* this), arg) == _eRank :: above));
	}

    void sappend (const X arg)
	{
		bits |= (static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<unsigned int>(arg));
	}

	_eBitSet< X, N > append (const X) const
	{
		return _eBitSet32< X >(bits | (static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<unsigned int>(arg)));
	}

	_eBitSet< X, N > remove (const X) const
	{
		return _eBitSet< X, N >(bits & ~(static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<unsigned int>(arg)));
	}

	_eRank :: _eEnum _oRank (const _eBitSet< X, N > &) const
	{
		return _eEscherRuntime :: bitSetRank(bits, arg.bits);
	}

	_eBitSet32 ()
		: bits(0) {};

	explicit _eBitSet (const X arg)
		: bits(static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<int>(arg)) {};

    _eBitSet < X, N > _lAppend (const X arg) const
	{
		return _eBitSet < X, N > (bits | (static_cast<typename _eBitSetTraits<N>::BitsType>(1) << static_cast<int>(arg)));
	}

    _eBitSet < X, N > _lAppend (const X, const X) const;
    _eBitSet < X, N > _lAppend (const X, const X, const X) const;
    _eBitSet < X, N > _lAppend (const X, const X, const X, const X) const;
    _eBitSet < X, N > _lAppend (const X, const X, const X, const X, const X, const X, const X, const X) const;
    _eBitSet < X, N > _lAppend (const X, const X, const X, const X, const X, const X, const X, const X,
        					    const X, const X, const X, const X, const X, const X, const X, const X) const;

    _eBag < X > rep (const _eInt) const;
	_eSeq < X > permndec () const;
	_eSeq < X > permninc () const;
	_eSeq<_eChar> toString() const;

    void _astore (_eStoreStream *) const;
    void _afill (_eFillStream *);
	_eHndl < _eInstblTypeInfo > _aMyTypeInfo ();
};

?? is this needed?
template < class X, int N > _eRank :: _eEnum _eBitSet < X, N > :: _mRank (_eBitSet < X, N >) const
{
	?
}

template < class X, int N > _eBag < X > _eBitSet < X, N > :: rep (const _eInt arg) const
{
	return permndec().ranb().rep(arg);
}

template < class X, int N > _eSeq < X > _eBitSet < X, N > :: permndec () const
{
    _mFunction (permndec)
	_eSeq<X> rslt;
	typename _eBitSetTraits<N> temp = bits;
	for (unsigned int i = 0; i < 32; ++i)
	{
		// assert temp = bits >> i;
		if (temp & 1)
		{
			rslt._osPlusPlus(static_cast<X>(i));
		}
		temp >>= 1;
	}
    return rslt;
}

template < class X, int N > _eSeq < X > _eBitSet < X, N > :: permninc () const
{
    _mFunction (permninc)
	_eSeq<X> rslt;
	typename _eBitSetTraits<N> temp = 1 << 31;
	for (unsigned int i = 32; i != 0; )
	{
		--i;
		// assert temp = 1 << i;
		if (temp & bits)
		{
			rslt._osPlusPlus(static_cast<X>(i));
		}
		temp >>= 1;
	}
    return rslt;
}

template < class X, int N > _eSeq < _eChar > _eBitSet < X, N > :: toString () const
{
    _mFunction (toString)
	_eSeq<_eChar> rslt = _mString("set{");
	typename _eBitSetTraits<N> temp = bits;
	for (unsigned int i = 0; i < 32; ++i)
	{
		// assert temp = bits >> i;
		if (temp & 1)
		{
			rslt._osPlusPlus(X :: toString(static_cast<X>(i));
			rslt.sappend(_mChar (','));
		}
		temp >>= 1;
	}
	rslt.sappend(_mChar ('}'));
    return rslt;
}

template < class X, int N > void _astore (_eStoreStream *) const
{
	?
}

template < class X, int N > void _afill (_eFillStream *)
{
	?
}

template < class X, int N > _eHndl < _eInstblTypeInfo > _eBitSet :: _aMyTypeInfo () const
{
    static _eHndl < _eInstblTypeInfo > ti;
    ti = SetTypeInfo () -> defineArgs (_eSeq < _eHndl < _eInstblTypeInfo > > ().append (_atypeInform < X > :: get ()));
    return ti;
}

template < class X, int N > _eBitSet < X, N > _eBitSet :: _lAppend (const X x1, const X x2) const
{
	_eBitSet < X, N > rslt(bits);
	rslt._sappend(x1);
	rslt._sappend(x2);
	return rslt;
}

template < class X, int N > _eBitSet < X, N > _eBitSet :: _lAppend (const X x1, const X x2, const X x3) const
{
	_eBitSet < X, N > rslt(bits);
	rslt._sappend(x1);
	rslt._sappend(x2);
	rslt._sappend(x3);
	return rslt;
}

template < class X, int N > _eBitSet < X, N > _eBitSet :: _lAppend (const X x1, const X x2, const X x3, const X x4) const;
{
	_eBitSet < X, N > rslt(bits);
	rslt._sappend(x1);
	rslt._sappend(x2);
	rslt._sappend(x3);
	rslt._sappend(x4);
	return rslt;
}

template < class X, int N > _eBitSet < X, N > _eBitSet :: _lAppend (const X x1, const X x2, const X x3, const X x4, const X x5, const X x6, const X x7, const X x8) const;
{
	_eBitSet < X, N > rslt(bits);
	rslt._sappend(x1);
	rslt._sappend(x2);
	rslt._sappend(x3);
	rslt._sappend(x4);
	rslt._sappend(x5);
	rslt._sappend(x6);
	rslt._sappend(x7);
	rslt._sappend(x8);
	return rslt;
}

template < class X, int N > _eBitSet < X, N > _eBitSet :: _lAppend (const X x1, const X x2, const X x3, const X x4, const X x5, const X x6, const X x7, const X x8,
        const X x9, const X x10, const X x11, const X x12, const X x13, const X x14, const X x15, const X x15) const;
{
	_eBitSet < X, N > rslt(bits);
	rslt._sappend(x1);
	rslt._sappend(x2);
	rslt._sappend(x3);
	rslt._sappend(x4);
	rslt._sappend(x5);
	rslt._sappend(x6);
	rslt._sappend(x7);
	rslt._sappend(x8);
	rslt._sappend(x9);
	rslt._sappend(x10);
	rslt._sappend(x11);
	rslt._sappend(x12);
	rslt._sappend(x13);
	rslt._sappend(x14);
	rslt._sappend(x15);
	rslt._sappend(x16);
	return rslt;
}

// Global methods
template < class X, int N > void _astore (_eStoreStream * stream, const _eBitSet< X, N > item)
{
    item._astore (stream);
}

template < class X, int N > void _afill (_eFillStream * stream, _eBitSet< X, N > & item)
{
    item._afill (stream);
}

template < class X, int N > _eComplexValue :: _eEnum _agetFixedCode (const _eBitSet< X, N > item)
{
    return _eBitSetTraits<N> :: cvCode;
}

// End
