// ******************************************************************************
// * File:   Union.cpp															*
// * Target: C++ version of Perfect Developer runtime system					*
// * Author: (C) 2001 Escher Technologies Ltd.									*
// * Desc:   Definition of non-inline member methods of classes in Union		*
// ******************************************************************************

#include "Ertsys.hpp"

//------------------------------------------------------------------------------------------------------------------
// Routines to implement persistant storage of unions
//------------------------------------------------------------------------------------------------------------------

//??? This schema would not be required to do anything if we could implement the commented-out code in ClassTypeDecls.pd
//    for storing unions. For now, it will do the job of invoking the storage stream schema 'storeUnion(..)' ...
void _eUnion :: _astore(_eStoreStream* stream) const
{
	stream -> _astoreUnion(*this);
}

// This schema will be called for filling template classes instantiated with universal unions. For objects of universal union type
// this call could be optimised out by calling _afillUnion directly, however this is not implemented at present.
void _eUnion :: _afill(_eFillStream* stream)
{
	_eUnion temp;
	stream -> _afillUnion(temp, true);		// fill, allowing 'null'
	Object = temp.Object;
	// The object's use-count will get decremented when 'temp' goes out of scope, so need to bump it
	AddLink();
}

// This store schema actually stores the held object in the stream. It is called from the _astoreUnion(..) schema in the storage stream class
void _eUnion :: _adoStore(_eStoreStream* stream) const
{
	_mFunction(doStore);
	_mBeginPre _mCheckPre(Object != NULL, "0,0")
	Object -> _astore(stream);				// calls the _astore in the user class (generated by the Perfect Developer Tool)
}

// Function to return an instantiable type-info object that describes the storable type held inside this union
_eHndl < _eInstblTypeInfo > _eUnion :: _aGetMyTypeInfo() const
{
	_mFunction(getMyTypeInfo);
	_mBeginPre _mCheckPre(dynamic_cast<_eStorable*>(Object) != NULL, "0,0");
	_mBeginPre _mCheckPre(Object != NULL, "0,0")
    static _eHndl < _eInstblTypeInfo > ti;
    ti = static_cast<_eStorable*>(Object) -> _aGetMyTypeInfo();
    return ti;
}

// Function to return an instantiable type-info object that describes a universal union (used for matching purposs only,
// since this function will only get called when generating a full type description of a template instantiation with a universal union)
_eHndl<_eInstblTypeInfo> _eUnion :: _aMyTypeInfo()
{
    static _eHndl < _eInstblTypeInfo > ti;
    ti = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_UNION, false));
    return ti;
}

// End
