// **************************************************************************
// * File:   Order.cpp											   			*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement ordering mechanism between items				*
// **************************************************************************

#include "Ertsys.hpp"

//---------------------------------
// Names of rank enumeration values
//---------------------------------
const _eNativeChar* _eRank::_lnaming[3] =
    {
		_mCstr("below"), _mCstr("same"), _mCstr("above")
	};

//-------------------------
// Relative rank for unions
//-------------------------

_eRank :: _eEnum _oRank(const _eUnion& x, const _eUnion& y)
{
	return x.Ptr() == NULL
			? (y.Ptr() == NULL ? _eRank :: same : _eRank :: below)
			: y.Ptr() == NULL
			? _eRank :: above
			: x->_oRank(y.Ptr());
}

// End
