// **************************************************************************
// * File:   Heaps.cpp											   			*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement heap and reference mechanism					*
// **************************************************************************

//---------
// Includes
//---------

#include "Ertsys.hpp"
#include "Heaps.hpp"

//--------------------
// Code for _eHeapLink
//--------------------

// Constructor
_eHeapLink::_eHeapLink(_eHeap* heap)
  : Previous(heap), UseCount(1), IsDestroyedFlag(false)
{
    Next = heap->Next;
    heap->Next = this;
	if (Next != NULL)
	{
		Next->Previous = this;
	}
}
// Destructor
_eHeapLink::~_eHeapLink()
{
	_mCannotHappen(UseCount > 0, "Not ready to delete heap element");
	Previous->Next = Next;
	if (Next != NULL)
	{
		Next->Previous = Previous;
	}
}

//----------------
// Code for _eHeap
//----------------

// Destructor
_eHeap::~_eHeap()
{
	#if defined(NDEBUG)
		// If we have terminated a release build, no need to destory objects on a heap.
		if (_eEscherRuntime :: Terminated) return;
	#endif

	_eHeapLink* link = Next;
	// Pass#1: Eliminate the objects on the heap
	while(link != NULL )
	{

		link->Destroy();
		link = link->Next;
			// destroy this link
	}
	link = Next;
	// Pass#2: Eliminate all of the heap elements that are not referenced.
	while(link != NULL )
	{
		_eHeapLink* current = link;
		link = link->Next;
		if ( current->UseCount == 0) {
			delete current;
		}
	}
}

// Function for dishing out heap-element serial numbers - called by the normal heap-elem CTOR ...
// Note that this will wrap around eventually, so heap-elements are not guaranteed to have a strict ordering, but this
// is not an issue; the issue is that any ref's in a serialised object order the same in the de-serialised version.
_eNat _eEscherRuntime::getNextSerialNumber()
{
	static _eNat nextNumber = 0;
	return nextNumber++;
}

// End.
