// **************************************************************************
// * File:   Any.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definitions of base class for all handle classes (_eAny).		*
// **************************************************************************

#if !defined(_h_Any)
#define _h_Any 1

//------------------------------------------------------------------------------------------------------------------
// Class '_eFullTypeInfo' - class to hold type-info about a class and a reference to the parent's full-type-info
// to allow us to recurse up the type tree in the rank logic. The 'AnyBase' class declares a deferred function that
// returns an instance this of this class ...
//------------------------------------------------------------------------------------------------------------------

class _eFullTypeInfo
{
	_eHndl<_eInstblTypeInfo> myTypeInfo;
	int gen;
	const _eFullTypeInfo *parentTypeInfo;
  public:
	// normal CTOR ...
	_eFullTypeInfo(const _eHndl<_eInstblTypeInfo> myti, int thegen, const _eFullTypeInfo *parti)
		: myTypeInfo(myti), gen(thegen), parentTypeInfo(parti) {}
	// default CTOR to allow us to declare objects of this type ...
	_eFullTypeInfo()
		: myTypeInfo(_eHndl<_eInstblTypeInfo>()), gen(0), parentTypeInfo((_eFullTypeInfo *)NULL) {}

	_eHndl<_eInstblTypeInfo> typeInfo() const
	{
		return myTypeInfo;
	}
	_rstring name() const;
	int generation() const
	{
		return gen;
	}
	const _eFullTypeInfo *parent() const
	{
		return parentTypeInfo;
	}
	// equality on these objects doesn't bother checking parent chains - as long as the type-info and the
	// generation are the same, we conosider the object equal ...
	_eBool operator==(const _eFullTypeInfo *other) const;
};

//-----------------------------------------------------
// Class '_eAny' - base class for all handle classes...
//-----------------------------------------------------

class _eAny : public _eAnyBase
{
  public:
	virtual _eSeq<_eChar> toString() const
	{
		return _mString("No output string defined for this class");
	}

	virtual const std::type_info& _lType() const
	{
		return typeid(_eAny);
	}

	virtual _eAddress _rthis() const
	{
		return static_cast<_eAddress>(this);
	}

	// Perfect type-info - all compiled Perfect classes generate a definition of this function ...
	virtual _eHndl<_eInstblTypeInfo> _aGetMyTypeInfo() const;
};

// Functionality from the 'anything' class
namespace _eAnything
{
	inline _eSeq<_eChar> toString(const _eAny* const Object)
	{
		return (Object == NULL ? _mString("null") : Object -> toString());
	}
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
