// Simple Java Swing application to front-end a Perfect Developer program

package DictionaryTest;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import Ertsys.*;

// This is the top-level class
public class DictionaryAccess implements ActionListener
{
    JFrame appFrame;
    JPanel appPanel;
    JTextField wordToUse;
    JLabel status;
    JButton addButton, removeButton, checkButton;
		DictionaryWrapper backend;

    // Constructor
    public DictionaryAccess()
		{
			// Create the back end
			backend = new DictionaryWrapper();

			// Create the frame and container.
			appFrame = new JFrame("Exercise the Dictionary class");
			appPanel = new JPanel();
			appPanel.setLayout(new BorderLayout(10, 10));
			appPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

			// Add the widgets.
			addWidgets();

			// Add the panel to the frame.
			appFrame.getContentPane().add(appPanel, BorderLayout.CENTER);

			// Exit when the window is closed.
  		appFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

			// Show the app.
			appFrame.pack();
			appFrame.setVisible(true);
    }

    // Create and add the widgets for app.
    private void addWidgets()
		{
			// Create widgets.
			wordToUse = new JTextField(20);
			status = new JLabel("Result", SwingConstants.LEFT);
			addButton = new JButton("Add to dictionary");
			removeButton = new JButton("Remove from dictionary");
			checkButton = new JButton("Check if in dictionary");

			// Listen to events from Convert button.
			addButton.addActionListener(this);
			removeButton.addActionListener(this);
			checkButton.addActionListener(this);

			// Add widgets to container.
			appPanel.add(wordToUse, BorderLayout.NORTH);
			appPanel.add(status, BorderLayout.SOUTH);
			appPanel.add(addButton, BorderLayout.WEST);
			appPanel.add(removeButton, BorderLayout.CENTER);
			appPanel.add(checkButton, BorderLayout.EAST);

  		status.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
    }

    // Implementation of ActionListener interface.
    public void actionPerformed(ActionEvent event)
		{
			String word = wordToUse.getText();
			if (event.getSource() == addButton)
			{
				DictionaryResultCode rslt = new DictionaryResultCode();
				backend.add(_eSystem._lString(word), (char)0, rslt);
				setResult(rslt.value, word);
			}
			else if (event.getSource() == removeButton)
			{
				DictionaryResultCode rslt = new DictionaryResultCode();
				backend.remove(_eSystem._lString(word), (char)0, rslt);
				setResult(rslt.value, word);
			}
			else if (event.getSource() == checkButton)
			{
				setResult(backend.check(_eSystem._lString(word), (char)0), word);
			}
			else status.setText("Unknown event or return code");
		}

		public void setResult(int rslt, String word)
		{
			if (rslt == DictionaryResultCode.no)
			{
				status.setText("'" + word + "' is not in the dictionary");
			}
			else if (rslt == DictionaryResultCode.yes)
			{
				status.setText("'" + word + "' is in the dictionary");
			}
			else if (rslt == DictionaryResultCode.added)
			{
				status.setText("'" + word + "' has been added to the dictionary");
			}
			else if (rslt == DictionaryResultCode.removed)
			{
				status.setText("'" + word + "' has been removed from the dictionary");
			}
			else if (rslt == DictionaryResultCode.badWord)
			{
				status.setText("'" + word + "' is not a valid word");
			}
			else
			{
				status.setText("Unknown result code");
			}
    }

    // main method
    public static void main(String[] args)
		{
			// Set the look and feel.
			try
			{
			  UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
			} catch(Exception e) {}

			DictionaryAccess applicationObject = new DictionaryAccess();
    }
}

// End
