/****************************************************************************
Platform check file for Escher C Verifier
Verifying this source file with eCv will check that the configured
compiler/platform dependencies match the values given in file "limits.h".
If any verification failures occur:
- Check that you have selected the correct compiler in the project settings
- Check that the type sizes and other platform-depeendent values are set
  correctly in that compiler configuration in the eCv project Manager
- Check that the include path is correctly configured in the compiler
  configuration, so that the correct limits.h file is being included
*****************************************************************************/

#include <ecv.h>
#include <limits.h>

void ccheck0()
{
	assert ((1u << (unsigned int) CHAR_BIT) - 1u == maxof(unsigned char));
}

void ccheck1()
{
	assert(SCHAR_MIN == minof(signed char));
}

void ccheck2()
{
	assert(SCHAR_MAX == maxof(signed char));
}

void ccheck3()
{
	assert(UCHAR_MAX == maxof(unsigned char));
}

void scheck1()
{
	assert(SHRT_MIN == minof(short));
}

void scheck2()
{
	assert(SHRT_MAX == maxof(short));
}

void scheck3()
{
	assert(USHRT_MAX == maxof(unsigned short));
}

void icheck1()
{
	assert(INT_MIN == minof(int));
}

void icheck2()
{
	assert(INT_MAX == maxof(int));
}

void icheck3()
{
	assert(UINT_MAX == maxof(unsigned int));
}

void lcheck1()
{
	assert(LONG_MIN == minof(long));
}

void lcheck2()
{
	assert(LONG_MAX == maxof(long));
}

void lcheck3()
{
	assert(ULONG_MAX == maxof(unsigned long));
}

/* End */
