/* File limits.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_limits_h_included__)
#define __ecv_limits_h_included__

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

# define CHAR_BIT	(__ECV_CHAR_BITS__)

/* The following all assume 2s complement representation (as does eCv).
 * They need to be in a form suitable for use in preprocessor expressions, so no casts allowed.
 * Unfortunately, this means that when they are used in a non-preprocessor context, this will
 * result in signed/unsigned warnings. */

# define SCHAR_MIN	(-(1 << ((__ECV_CHAR_BITS__) - 1u)))
# define SCHAR_MAX	((1 << ((__ECV_CHAR_BITS__) - 1u)) - 1)
# define UCHAR_MAX	((1 << (__ECV_CHAR_BITS__)) - 1)

# define SHRT_MIN	(-(1 << ((__ECV_SHORT_BITS__) - 1u)))
# define SHRT_MAX	((1 << ((__ECV_SHORT_BITS__) - 1u)) - 1)
# define USHRT_MAX	((1 << (__ECV_SHORT_BITS__)) - 1)

# define INT_MIN	(-(1 << ((__ECV_INT_BITS__) - 1u)))
# define INT_MAX	((1 << ((__ECV_INT_BITS__) - 1u)) - 1)
# define UINT_MAX	((1 << (__ECV_INT_BITS__)) - 1)

# define LONG_MIN	(-(1 << ((__ECV_LONG_BITS__) - 1u)))
# define LONG_MAX	((1 << ((__ECV_LONG_BITS__) - 1u)) - 1)
/* Need to avoid overflow in defining ULONG_MAX because the eCv preprocessor flags overflow for 1 << 64 */
# define ULONG_MAX	((((1 << ((__ECV_LONG_BITS__) - 1u)) - 1) << 1) + 1)

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* Extra definitions for C'99 */
#   define LLONG_MIN	(-(1 << ((__ECV_LONG_LONG_BITS__) - 1u)))
#   define LLONG_MAX	((1 << ((__ECV_LONG_LONG_BITS__) - 1u)) - 1)
/* Need to avoid overflow in defining ULLONG_MAX because the eCv preprocessor flags overflow for 1 << 64 */
#	define ULLONG_MAX	((((1 << ((__ECV_LONG_LONG_BITS__) - 1u)) - 1) << 1) + 1)

# endif

/* In defining MB_LEN_MAX we assume multibyte characters are encoded in UTF-8 form */
# define MB_LEN_MAX		(4)

#else
# error Missing macro definitions!. Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
