// **************************************************************************
// * File:   StorableSupport.cpp											*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Declarations of global schemas used to store elements of		*
// *         collections.													*
// **************************************************************************

#include "Ertsys.hpp"

// Global versions of store(..) schema so we can store collections of templated types

void _astoreGlobal(_eStoreStream* stream, const _eInt item)
{
	stream -> _astore(item);
}
void _astoreGlobal(_eStoreStream* stream, const _eBool item)
{
	stream -> _astore(item);
}
void _astoreGlobal(_eStoreStream* stream, const _eChar item)
{
	stream -> _astore(item);
}
void _astoreGlobal(_eStoreStream* stream, const _eReal item)
{
	stream -> _astore(item);
}
void _astoreGlobal(_eStoreStream* stream, const _eByte item)
{
	stream -> _astore(item);
}
void _astoreGlobal(_eStoreStream* stream, const _eUnion & item)
{
	item._astore(stream);
}

// Global versions of fill(..) schema so we can load collections of templated types

void _afillGlobal(_eFillStream* stream, _eInt & item)
{
	stream -> _afill(item);
}
void _afillGlobal(_eFillStream* stream, _eBool & item)
{
	stream -> _afill(item);
}
void _afillGlobal(_eFillStream* stream, _eChar & item)
{
	stream -> _afill(item);
}
void _afillGlobal(_eFillStream* stream, _eReal & item)
{
	stream -> _afill(item);
}
void _afillGlobal(_eFillStream* stream, _eByte & item)
{
	stream -> _afill(item);
}
void _afillGlobal(_eFillStream* stream, _eUnion & item)
{
	item._afill(stream);
}

// Type-info constants for the builtin templates in the runtime system. For type-infos for builtin non-template
// types see file LoadableSupport_1.hpp (we use the '_mBuiltinTypeInform' macro in that case) ...

_eHndl < _eInstblTypeInfo > SeqTypeInfo ()
{
    _mBeginConstant (_vConstValue_17_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_17_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_SEQ, false));
    _mEndConstant (_vConstValue_17_7)
}

_eHndl < _eInstblTypeInfo > SetTypeInfo ()
{
    _mBeginConstant (_vConstValue_18_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_18_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_SET, false));
    _mEndConstant (_vConstValue_18_7)
}

_eHndl < _eInstblTypeInfo > BagTypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_BAG, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > MapTypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_MAP, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > PairTypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_PAIR, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > TripleTypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_TRIPLE, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > Multiple2TypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_MULTIPLE2, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > Multiple3TypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_MULTIPLE3, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > Multiple4TypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_MULTIPLE4, false));
    _mEndConstant (_vConstValue_19_7)
}

_eHndl < _eInstblTypeInfo > RefTypeInfo ()
{
    _mBeginConstant (_vConstValue_19_7, _eHndl < _eInstblTypeInfo >)
    _vConstValue_19_7 = _eHndl<_eInstblTypeInfo>(new _eInstblTypeInfo(_estcBasicTypeCode :: BUILTIN_TYPEIDX_REF, false));
    _mEndConstant (_vConstValue_19_7)
}

//------------------------------------------------------------------
// Macro defining store, fill and representedByCode methods for rank
//------------------------------------------------------------------

_mEnumStorableSupportBdy(_eRank, _eRank)

// End.
