// **************************************************************************
// * File:   Debug.cpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Implementations of special 'debug' functionality defined in 	*
// *         the runtime. Note that these functions should not be generally	*
// *         used since they buck the idea of a single program environment.	*
// **************************************************************************

#include "Ertsys.hpp"

// Print a string to the console for debugging purposes
void _ltrace(const _rstring s)
{
	const _eCstring temp(s);
#if defined(_dUnicode)
	printf("%ls", temp.str());
#else
	printf("%s", temp.str());
#endif
	fflush(stdout);
}

// End.
