// **************************************************************************
// * File:   Types.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Various typedefs and includes.	 								*
// **************************************************************************

#if !defined(_h_types)
#define _h_types

//----------------------------------------
// Some imports and types for internal use
//----------------------------------------

#include <typeinfo>				// RTTI header
#include <cstring>				// for memcopy, memset and memmove
#include <cstddef>
#include <climits>	 			// for UINT_MAX

//--------------------------------------------
// Typedefs for ANSI compatible built in types
//--------------------------------------------

typedef bool 			_eBool;
typedef unsigned char	_eByte;

#if defined(_dUnicode)
 typedef wchar_t		_eNativeChar;
 typedef wchar_t		_eChar;				// use Unicode character set
 typedef const wchar_t*	_eCstr;
 typedef unsigned int	_eUnsignedChar;		// an unsigned type at least as large as a character
 #define _mCstr2(str)	L ## str			// use long string literals
 #define _mCstr(str)	_mCstr2(str)		// need this to make __FILE__ get expanded before _()
 #define _mCurrentFile	_mCstr(__FILE__)
#else
 typedef char			_eNativeChar;
 typedef signed char	_eChar;				// use ASCII character set
 typedef const char*	_eCstr;
 typedef unsigned char	_eUnsignedChar;		// an unsigned type at least as large as a character
 #define _mCstr(str)	str					// use ASCII string literals
 #define _mCurrentFile	__FILE__
#endif

// Determine a suitable type for a Perfect 'int'. This should be as large as a pointer.
// The following doesn't work because sizeof(...) doesn't yield an integer constant under WIN64
//#if sizeof(char *) == sizeof(int)
//  typedef int			_eInt;
//#elif sizeof(char *) == sizeof(long int)
//  typedef long		_eInt;
//#elif defined(_WIN64)
//  typedef __int64		_eInt;
//#else
//  #error Unable to determine the correct typedef for _eInt
//#endif

#if defined(_WIN64)
  typedef __int64		_eInt;
  const _eInt _lMaxInt = _I64_MAX;
#else
  typedef int			_eInt;
  const _eInt _lMaxInt = INT_MAX;
#endif

typedef _eInt    		_eNat;
typedef double          _eReal;
typedef int				_eTag;

// Type used as a use count, and a distinguished value that is not a legal use count.
// We assume a reasonable limit on sharing counts here, although for complete safety we should use the same size as _eInt, or size_t
typedef int _eUseCount;
const _eUseCount _lUnsharableValue = INT_MIN;		// this needs to be significantly negative - we add it to the use count to indicate that the object is unshareable

// Type used to store the size of an object, and its maximum value
typedef size_t			_eSize;

// The following defined the maximum number of digits that the C function 'sprintf' function may generate
// when asked to print an int, unsigned int, long or unsigned long (not including a null terminator)
// We are allowing here for 64-bit integers so the max unsigned value is about 16 * 10^18 which is 20 digits
// The most negative value will be -8 * 10^18 which is also 20 digits
const int _lDigitsMax = 20;

//----------------------------------------
// Typedefs for compiler defined functions
//----------------------------------------

typedef const void *	_eAddress;

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
