// **************************************************************************
// * File:   MiscMacs.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Miscellaneous macros.	 										*
// **************************************************************************

#if !defined(_h_miscmacs)
#define _h_miscmacs

//---------------------
// Miscellaneous macros
//---------------------

#define _mComma ,				// used to separate template parameters
#define _mNoact			        // 'do nothing' macro

#if defined(__BCPLUSPLUS__)
  // Borland C++ 5.5.1 gives message "Warning 8058: Can't use precompiled header: Header incomplete"
  // whenever a header file ends in a template function definition.
  // We avoid this by generating the following macro at the end of each header file.
  #define _mBorlandFix	extern void _lBorlandDummy();
#endif

//----------------------------------------------------------------------------------
// Macro used for converting C++ string literals to 'Perfect' strings.
// Note this is faster than calling _lString
// Must be defined here as it is used in 'toString' members of built
// in types.
// Note: DO NOT change the following definition to:
//       "(_eSeq<_eChar>(sizeof(str)/sizeof(char) - 1, str))"
//   because MS VC++ 6 gets confused if brackets are placed around constructor calls
//----------------------------------------------------------------------------------

#if defined(_dUnicode)
 #define _mChar(ch)			(L ## ch)
 #define _mString(str)		_eSeq<_eChar>(sizeof(L ## str)/sizeof(wchar_t) - 1, L ## str)
#else
 #define _mChar(ch)			static_cast<_eChar>(ch)
 #define _mString(str)		_eSeq<_eChar>(sizeof(str)/sizeof(char) - 1, str)
#endif

//----------------------------------------------------------------------------------
// Macro used to generate integer literals
//----------------------------------------------------------------------------------
#if defined(_WIN64)
 #define _mInteger(digits)	digits ## i64
#else
 #define _mInteger(digits)	digits
#endif

//--------------------------------------
// create null pointer of specified type
//--------------------------------------

#define _mNullPtr(X)	(static_cast<const X*>(0))

//----------------------------------------
// nothing (dummy argument to constructor)
//----------------------------------------

#define _mNull

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
