// Method bodies for class _eRef<X>
// Sepearated from file From.hpp for full ANSI compliance
// D. Crocker, 2009-05-17

#if ! defined (_hInline_Heaps)
#define _hInline_Heaps

// Destructor
template<class X> _eRef<X >::~_eRef()
{
	if (Element != NULL)
	{
		Element->DecUseCount();
		if (Element->CanDelete())
		{
			delete Element;
		}
		Element = NULL;
	}
}

// Copy constructor
template<class X> _eRef<X >::_eRef(const _eRef& ref) :
	Element(ref.Element)
{
	if (Element != NULL)
	{
		Element->IncUseCount();
	}
	heapAddr = ref.heapAddr;
}

// Assignment operator
template<class X> _eRef<X >& _eRef<X >::operator=(const _eRef& ref)
{
	if (Element != NULL)
	{
		Element->DecUseCount();
	}
	if (Element != NULL && Element->CanDelete())
	{
		delete Element;
	}
	Element = ref.Element;
	heapAddr = ref.heapAddr;
	if (Element != NULL)
	{
		Element->IncUseCount();
	}
	return *this;
}

// Function to return an instantiable type-info object that describes this instantiation of _eRef ...
template<class X > _eHndl<_eInstblTypeInfo> _eRef<X >::_aMyTypeInfo()
{
    static _eHndl < _eInstblTypeInfo > ti;
    ti = RefTypeInfo()->defineArgs(_eSeq <_eHndl<_eInstblTypeInfo> >().append(_atypeInform<X >::get()));
    return ti;
}

// This store schema is not used for the case where we store a data member of type _eRef<X>, since the code generation
// optimizes this by calling the _astoreRef(..) schema in the storage stream class directly. For the other cases (ie.
// where we have a collection of ref's; a template class instantiated with ref and that has a data member of that type;
// or a union involving ref) we forward the store request on to the storage-stream, passing the address of the target heap
// so that the stream can find a heap index (the stream keeps track of all heap names via HeapInfo objects, and the addresses
// of the corrosponding heap; note that the heap is guaranteed to have been registered at this point because the '_astoreMembers'
// schema makes calls to the heap registering schema in the stream for all heaps involved in the union). The storage stream
// then call the '_adoStore(..) schema (see below) to actually store the reference object
template<class X > void _eRef<X >::_astore(_eStoreStream* stream) const
{
	//printf("\nStoring 'ref that came from a union' ... "); fflush(NULL);
	if (Element == NULL)
	{
		stream -> registerNullObject();
	}
	else
	{
		stream -> _astoreRefForUnion(*this, heapAddr);	// this call is misnamed - should be something like '_astoreRefIndirect(..)'
	}
}

// This fill schema is only used when we fill a universal union of a ref and something non-void. This ref will have been
// created on the heap via the instantiation table / instantiate function system (except in the case of a union of a ref
// with void, when this ref instance will have been created by the default ref constructor simply because of the declaration
// in the target class that we're filling) ...
template<class X > void _eRef<X >::_afill(_eFillStream* stream)
{
	//printf("\nFilling 'ref from a universal-union' ... "); fflush(NULL);
	stream -> _afillRef(*this);
}

// This store schema actually stores the referenced object in the stream. It is called from the _astoreRef(..) schema in
// the storage stream class ...
template<class X > void _eRef<X >::_adoStore(_eStoreStream* stream) const
{
	//printf("\nperforming store ... "); fflush(NULL);
	:: _astoreGlobal(stream, Element -> Object);
}

// This fill schema actually fills the referenced object from the stream. It is called from the _afillRef(..) schema in
// the storage stream class ...
template<class X > void _eRef<X >::_adoFill(_eFillStream* stream)
{
	//printf("\nperforming fill ..."); fflush(NULL);
	:: _afillGlobal(stream, Element -> Object);
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
