// Helper definitions for supporting Unicode character sets
// This is not intended to be included in code generated from Perfect. it is for use only within hand-coded C++ library modules.
// D. Crocker, 2009-05-16

#if !defined(_h_CharHelpers)
#define _h_charHelpers

#if !defined(_MSC_VER)
#include <alloca.h>
#endif

#if defined(_dUnicode)
 // Macro to convert a wide character string to a narrow character string
 // Do not use this in a loop, it allocates stack memory using _alloca!
 #define wcs2ncs(ns, ws) \
	{	\
		const size_t len = wcstombs(0, ws, 0) + 1;	\
		ns = reinterpret_cast<char*>(alloca(len * sizeof(char))); \
		wcstombs(ns, ws, len);	\
	}

 // Macro to convert a narrow character string to a wide character string
 // Do not use this in a loop, it allocates stack memory using _alloca!
 #define ncs2wcs(ws, ns) \
	{	\
		const size_t len = mbstowcs(0, ns, 0) + 1;	\
		ws = reinterpret_cast<_eNativeChar*>(alloca(len * sizeof(_eNativeChar))); \
		mbstowcs(ws, ns, len);	\
	}

 // Function selection for Unicode
 #define _mAccess	_waccess
 #define _mFgets	fgetws
 #define _mFopen	_wfopen
 #define _mFprintf	fwprintf
 #define _mChdir	_wchdir
 #define _mChmod	_wchmod
 #define _mGetcwd	_wgetcwd
 #define _mRename	_wrename
 #define _mSnprintf	swprintf
 #define _mSpawnvp	_wspawnvp
 #define _mStat		_wstat
 #define _mStrcat	wcscat
 #define _mStrchr	wcschr
 #define _mStrcpy	wcscpy
 #define _mStrlen	wcslen
 #define _mUnlink	_wunlink
 #define _mUtime	_wutime

#else

 // Function selection for ASCII
 #define _mAccess	_access
 #define _mFgets	fgets
 #define _mFopen	fopen
 #define _mFprintf	fprintf
 #define _mChdir	_chdir
 #define _mChmod	_chmod
 #define _mGetcwd	_getcwd
 #define _mRename	rename
 #define _mSnprintf	snprintf
 #define _mSpawnvp	_spawnvp
 #define _mStat		_stat
 #define _mStrcat	strcat
 #define _mStrchr	strchr
 #define _mStrcpy	strcpy
 #define _mStrlen	strlen
 #define _mUnlink	_unlink
 #define _mUtime	_utime

#endif

#endif

