/* File string.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_string_h_included__)
#define __ecv_string_h_included__
#define __ecv_string_h_spec_included__

#pragma ECV noverify

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* Define size_t. We assume that size_t should be defined as an unsigned integral type just long enough to contain a pointer.
 * size_t is also defined in some other header files, hence the guard. */

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
#     define __ecv_size_t_defined__
#   endif
# endif

/* Define the NULL macro */

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

void* memcpy(void* s1, const void* s2, size_t n)
	_ecv_writes(s1.all)
	_ecv_pre(s1.lim >= n; s2.lim >= n)
	_ecv_pre(_ecv_disjoint(s2.all, s1.all))
	_ecv_returns(s1)
	_ecv_post(_ecv_equalBytes(s2, s1, n))
;

void* memmove(void* s1, const void* s2, size_t n)
	_ecv_writes(s1.all)
	_ecv_pre(s1.lim >= n; s2.lim >= n)
	_ecv_returns(s1)
	_ecv_post(_ecv_equalBytes(s2, s1, n))
;

int memcmp(const void* s1, const void* s2, size_t n)
	_ecv_pre(s1.lim >= n; s2.lim >= n)
	_ecv_post((_ecv_result == 0) == _ecv_equalBytes(s2, s1, n))
;

void *memchr(const void* s, int c, size_t n)
	_ecv_pre(s.lim >= n);

void* memset(void* s, int c, size_t n)
	_ecv_writes(s.all)
	_ecv_pre(s.lim >= n)
	_ecv_returns(s)
	_ecv_post(_ecv_allBytesAre(s, c, n))
;

char* _ecv_array strcpy(char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_writes(s1.all)
	_ecv_pre(_ecv_isNullTerminated(s2))
	_ecv_pre(_ecv_disjoint(s2.all, s1.all))
	_ecv_pre(s1.upb > strlen(s2))
	_ecv_returns(s1)
	_ecv_post(_ecv_isNullTerminated(s1))
	_ecv_post(strlen(s1) == strlen(s2))
	_ecv_post(_ecv_forall i _ecv_in 0..strlen(s2) :- s1[i] == s2[i])
;

char* _ecv_array strncpy(char* _ecv_array s1, const char* _ecv_array s2, size_t n)
	_ecv_writes(s1.all)
	_ecv_pre(_ecv_isNullTerminated(s2) || s2.lim >= n)
	_ecv_pre(_ecv_disjoint(s2.all, s1.all))
	_ecv_pre(n <= s1.lim)
	_ecv_returns(s1)
	_ecv_post(_ecv_forall i _ecv_in 0..s1.upb :- s1[i] == (_ecv_isNullTerminated(s2) && i <= strlen(s2) ? s2[i] : _ecv_old s1[i]))
;

char* _ecv_array strcat(char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_writes(s1.all)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
	_ecv_pre(_ecv_disjoint(s2.all, s1.all))
	_ecv_pre(s1.lim >= strlen(s2) + strlen(s1) + 1)
	_ecv_returns(s1)
	_ecv_post(_ecv_isNullTerminated(s1))
	_ecv_post(strlen(s1) == _ecv_old(strlen(s1)) + strlen(s2))
	_ecv_post(_ecv_forall i _ecv_in 0..(_ecv_old(strlen(s1)) - 1) :- s1[i] == _ecv_old s1[i])
	_ecv_post(_ecv_forall i _ecv_in 0..strlen(s2) :- s1[i + _ecv_old(strlen(s1))] == s2[i])
;

char* _ecv_array strncat(char* _ecv_array s1, const char* _ecv_array s2, size_t n)
	_ecv_writes(s1.all)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
	_ecv_pre(_ecv_disjoint(s2.all, s1.all))
	_ecv_pre(s1.lim >= strlen(s1) + n + 1)
	_ecv_returns(s1)
	_ecv_post(_ecv_isNullTerminated(s1))
	_ecv_post(strlen(s1) == _ecv_old(strlen(s1)) + (n < strlen(s2) ? n : strlen(s2)))
	_ecv_post(_ecv_forall i _ecv_in 0..(_ecv_old(strlen(s1)) - 1) :- s1[i] == _ecv_old s1[i])
	_ecv_post(_ecv_forall i _ecv_in 0..(n < strlen(s2) ? n : strlen(s2)) :- s1[i + _ecv_old(strlen(s1))] == s2[i])
	_ecv_post((n < strlen(s2)) => (s1[n + _ecv_old(strlen(s1))] == '\0'))
;

/* NOTE: the specifications of the remaining functions are incomplete (i.e. missing postconditions) */

int strcmp(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

int strncmp(const char* _ecv_array s1, const char* _ecv_array s2, size_t n)
	_ecv_pre(_ecv_isNullTerminated(s1) || s1.lim >= n)
	_ecv_pre(_ecv_isNullTerminated(s2) || s2.lim >= n)
;

int strcoll(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

size_t strxfrm(char* _ecv_array _ecv_null s1, const char* _ecv_array s2, size_t n)
	_ecv_writes(_ecv_not_null(s1).all)
	_ecv_pre(n == 0 || (s1 != 0 && _ecv_not_null(s1).lim >= n))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array _ecv_null _ecv_array strchr(const char* _ecv_array s, int c)
	_ecv_pre(_ecv_isNullTerminated(s))
;

size_t strcspn(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array _ecv_null strpbrk(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array _ecv_null strrchr(const char* _ecv_array s, int c)
	_ecv_pre(_ecv_isNullTerminated(s))
;

size_t strspn(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array _ecv_null strstr(const char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array _ecv_null strtok(char* _ecv_array s1, const char* _ecv_array s2)
	_ecv_writes(s1.all)
	_ecv_pre(_ecv_isNullTerminated(s1))
	_ecv_pre(_ecv_isNullTerminated(s2))
;

char* _ecv_array strerror(int)
	_ecv_post(_ecv_isNullTerminated(_ecv_result))
;

size_t strlen(const char* _ecv_array s)
	_ecv_pre(_ecv_isNullTerminated(s))
	_ecv_post(_ecv_result < s.lim)
	_ecv_post(s[_ecv_result] == '\0')
	_ecv_post(_ecv_forall i _ecv_in 0..(_ecv_result - 1) :- s[i] != '\0')
;

#else
# error Missing macro definitions! Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
