/*
 * Decompiled with CFR 0.152.
 */
package Ertsys;

import Ertsys.DebugType;
import Ertsys.FileAttribute;
import Ertsys.FileError;
import Ertsys.FileModeType;
import Ertsys.FilePath;
import Ertsys.FileRef;
import Ertsys.FileStats;
import Ertsys.OsInfo;
import Ertsys.SocketError;
import Ertsys.SocketMode;
import Ertsys.Time;
import Ertsys.UsefulFile;
import Ertsys.UsefulFileException;
import Ertsys._eAny;
import Ertsys._eSeq;
import Ertsys._eSet;
import Ertsys._eSocket;
import Ertsys._eStandardInputStream;
import Ertsys._eStandardOutputStream;
import Ertsys._eSystem;
import Ertsys._eWrapper__eAny;
import Ertsys._eWrapper_byte;
import Ertsys._eWrapper_char;
import Ertsys._eWrapper_int;
import Ertsys._eWrapper_real;
import Ertsys._xPre;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public final class Environment
extends _eAny {
    private String sPathname;
    private _eStandardInputStream myStdIn;
    private _eStandardOutputStream myStdOut;
    private _eStandardOutputStream myStdErr;
    private BufferedReader myInput;
    private Properties envVars;
    private long startTimeMillis;

    public boolean _lEqual(Environment environment) {
        _eSystem.trace("=");
        if (this == environment) {
            return true;
        }
        return this.sPathname == environment.sPathname || this.sPathname.equals(environment.sPathname);
    }

    @Override
    public boolean equals(_eAny _eAny2) {
        return _eAny2 == this || _eAny2 != null && _eAny2.getClass() == Environment.class && this._lEqual((Environment)_eAny2);
    }

    public Environment(String string) {
        _eSystem.trace("build");
        this.sPathname = string;
        this.myStdIn = new _eStandardInputStream(System.in);
        this.myStdOut = new _eStandardOutputStream(System.out);
        this.myStdErr = new _eStandardOutputStream(System.err);
        this.startTimeMillis = System.currentTimeMillis();
    }

    private byte[] genEightBitSeq(int n, int n2) {
        _eSystem.trace("genEightBitSeq");
        byte[] byArray = new byte[n2];
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            byArray[--n4] = (byte)(n3 & 0xFF);
            n3 >>= 8;
        }
        return byArray;
    }

    private int assembleEightBitSeq(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 8;
            n2 |= byArray[i];
        }
        return n2;
    }

    public _eStandardInputStream stdIn() {
        return this.myStdIn;
    }

    public _eStandardOutputStream stdOut() {
        return this.myStdOut;
    }

    public _eStandardOutputStream stdErr() {
        return this.myStdErr;
    }

    public void open(_eSeq _eSeq2, char c, _eSet _eSet2, FileModeType fileModeType, _eWrapper__eAny _eWrapper__eAny2, _eAny _eAny2) {
        _eSystem.trace("open");
        boolean bl = _eSet2._ovIn(new FileModeType(2));
        boolean bl2 = _eSet2._ovIn(new FileModeType(1));
        boolean bl3 = bl2 || bl;
        String string = bl3 ? "rw" : "r";
        File file = new File(_eSystem._lJavaString(_eSeq2));
        try {
            if (bl3 && file.exists() && !file.canWrite()) {
                _eWrapper__eAny2.value = new FileError(11);
            } else {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, string);
                if (bl2) {
                    randomAccessFile.setLength(0L);
                } else if (bl) {
                    randomAccessFile.seek(randomAccessFile.length());
                }
                _eWrapper__eAny2.value = new FileRef(randomAccessFile, bl3, _eSet2._ovIn(new FileModeType(0)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            _eWrapper__eAny2.value = new FileError(2);
        }
        catch (IOException iOException) {
            _eWrapper__eAny2.value = new FileError(16);
        }
        catch (SecurityException securityException) {
            _eWrapper__eAny2.value = new FileError(11);
        }
    }

    public void open(_eSeq _eSeq2, char c, int n, int n2, SocketMode socketMode, _eWrapper__eAny _eWrapper__eAny2, _eAny _eAny2) {
        _eSystem.trace("open");
        _eSocket _eSocket2 = new _eSocket(_eSeq2, '\u0000', n, n2, (SocketMode)null);
        int n3 = _eSocket2.getLastError();
        _eWrapper__eAny2.value = n3 == 0 ? _eSocket2 : new SocketError(n3);
    }

    public void open(_eSeq _eSeq2, byte by, int n, int n2, SocketMode socketMode, _eWrapper__eAny _eWrapper__eAny2, _eAny _eAny2) {
        _eSystem.trace("open");
        _eSocket _eSocket2 = new _eSocket(_eSeq2, 0, n, n2, (SocketMode)null);
        int n3 = _eSocket2.getLastError();
        _eWrapper__eAny2.value = n3 == 0 ? _eSocket2 : new SocketError(n3);
    }

    public void makeDirectory(_eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("makeDirectory");
        try {
            fileError.value = !new File(_eSystem._lJavaString(_eSeq2)).mkdirs() ? 14 : 0;
        }
        catch (SecurityException securityException) {
            fileError.value = 13;
        }
    }

    public void readLine(_eWrapper__eAny _eWrapper__eAny2, _eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("readLine");
        if (this.myInput == null) {
            this.myInput = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            String string = this.myInput.readLine();
            if (string == null) {
                fileError.value = 16;
            } else {
                fileError.value = 0;
                _eWrapper__eAny2.value = _eSystem._lString(string);
            }
        }
        catch (IOException iOException) {
            fileError.value = 11;
        }
    }

    public void readLine(FileRef fileRef, _eWrapper__eAny _eWrapper__eAny2, _eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("readLine");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        if (!fileRef.fileReadable()) {
            fileError.value = 11;
        } else {
            try {
                String string = fileRef.getFileHandle().readLine();
                if (string == null) {
                    fileError.value = 1;
                } else {
                    _eWrapper__eAny2.value = _eSystem._lString(string);
                    fileError.value = 0;
                }
            }
            catch (IOException iOException) {
                fileError.value = 16;
            }
        }
    }

    public void move(_eSeq _eSeq2, char c, _eSeq _eSeq3, char c2, boolean bl, FileError fileError) {
        _eSystem.trace("move");
        File file = new File(_eSystem._lJavaString(_eSeq2)).getAbsoluteFile();
        File file2 = new File(_eSystem._lJavaString(_eSeq3)).getAbsoluteFile();
        if (file.getPath().equals(file2.getPath())) {
            fileError.value = 12;
            return;
        }
        try {
            if (file.isDirectory()) {
                fileError.value = 16;
                return;
            }
            if (!file.isFile()) {
                fileError.value = 2;
                return;
            }
            if (file2.isFile()) {
                if (!bl) {
                    fileError.value = 11;
                    return;
                }
                if (!file2.delete()) {
                    fileError.value = 10;
                    return;
                }
            }
            if (!file.renameTo(file2)) {
                fileError.value = 16;
                return;
            }
        }
        catch (SecurityException securityException) {
            fileError.value = 16;
            return;
        }
        fileError.value = 0;
    }

    public void flush(FileRef fileRef, FileError fileError) {
        _eSystem.trace("flush");
        fileError.value = 0;
    }

    public void close(FileRef fileRef, FileError fileError) {
        _eSystem.trace("close");
        try {
            fileRef.getFileHandle().close();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 16;
        }
    }

    public void delete(_eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("delete");
        try {
            File file = new File(_eSystem._lJavaString(_eSeq2));
            fileError.value = !file.exists() ? 2 : (file.isDirectory() || !file.canWrite() || !file.delete() ? 10 : 0);
        }
        catch (SecurityException securityException) {
            fileError.value = 11;
        }
    }

    public void seek(FileRef fileRef, int n, FileError fileError) {
        _eSystem.trace("seek");
        try {
            fileRef.getFileHandle().seek(n);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 9;
        }
    }

    public void fastForward(FileRef fileRef, FileError fileError) {
        _eSystem.trace("fastForward");
        try {
            this.seek(fileRef, (int)fileRef.getFileHandle().length(), fileError);
        }
        catch (IOException iOException) {
            fileError.value = 9;
        }
    }

    public void rewind(FileRef fileRef, FileError fileError) {
        _eSystem.trace("rewind");
        this.seek(fileRef, 0, fileError);
    }

    public boolean fileValid(_eSeq _eSeq2, char c) {
        _eSystem.trace("fileValid");
        File file = new File(_eSystem._lJavaString(_eSeq2));
        return file.exists();
    }

    public _eAny fileStatus(_eSeq _eSeq2, char c) {
        File file;
        _eSystem.trace("fileStatus");
        String string = _eSystem._lJavaString(_eSeq2);
        boolean bl = false;
        int n = string.length() - 1;
        if (string.charAt(n) == Environment.pathSeparator()) {
            string = string.substring(0, n);
            bl = true;
        }
        if (!(file = new File(string)).exists()) {
            return new FileError(2);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(file.lastModified()));
        Time time = new Time(gregorianCalendar.get(13), gregorianCalendar.get(12), gregorianCalendar.get(11), ((_eWrapper_int)_eSystem.dayMap()._oIndex((_eAny)new _eWrapper_int((int)gregorianCalendar.get((int)7)))).value, gregorianCalendar.get(5), ((_eWrapper_int)_eSystem.monthMap()._oIndex((_eAny)new _eWrapper_int((int)gregorianCalendar.get((int)2)))).value, gregorianCalendar.get(1));
        Time time2 = new Time(0, 0, 0, 1, 1, 1, 2001);
        _eSet _eSet2 = new _eSet();
        boolean bl2 = file.isDirectory();
        if (bl && !bl2) {
            return new FileError(3);
        }
        if (bl2) {
            _eSet2 = _eSet2._lAppend(new FileAttribute(6));
        }
        if (file.canWrite()) {
            _eSet2 = _eSet2._lAppend(new FileAttribute(1));
        }
        if (file.canRead()) {
            _eSet2 = _eSet2._lAppend(new FileAttribute(0));
        }
        FileStats fileStats = new FileStats(time2, time, time2, _eSet2, null, bl2 ? 0 : (int)file.length());
        return fileStats;
    }

    public void setMode(_eSeq _eSeq2, char c, _eSet _eSet2, FileAttribute fileAttribute, FileError fileError) {
        _eSystem.trace("setMode");
        fileError.value = 16;
    }

    public void forceFileTime(_eSeq _eSeq2, char c, Time time, Time time2, FileError fileError) {
        _eSystem.trace("forceFileTime");
        if (time == null && time2 != null) {
            fileError.value = 11;
            return;
        }
        try {
            File file = new File(_eSystem._lJavaString(_eSeq2));
            if (!file.exists()) {
                fileError.value = 2;
            } else {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(13, time.seconds);
                gregorianCalendar.set(12, time.minutes);
                gregorianCalendar.set(11, time.hours);
                gregorianCalendar.set(7, ((_eWrapper_int)_eSystem.revDayMap()._oIndex((_eAny)new _eWrapper_int((int)time.day))).value);
                gregorianCalendar.set(5, time.date);
                gregorianCalendar.set(2, ((_eWrapper_int)_eSystem.revMonthMap()._oIndex((_eAny)new _eWrapper_int((int)time.month))).value);
                gregorianCalendar.set(1, time.year);
                file.setLastModified(gregorianCalendar.getTime().getTime());
                fileError.value = 0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            fileError.value = 16;
        }
        catch (SecurityException securityException) {
            fileError.value = 16;
        }
    }

    public void fileSize(FileRef fileRef, _eWrapper_int _eWrapper_int2, FileError fileError) {
        _eSystem.trace("fileSize");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            _eWrapper_int2.value = (int)fileRef.getFileHandle().length();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 9;
        }
    }

    public void tell(FileRef fileRef, _eWrapper_int _eWrapper_int2, FileError fileError) {
        _eSystem.trace("tell");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            _eWrapper_int2.value = (int)fileRef.getFileHandle().getFilePointer();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 9;
        }
    }

    public void print(_eSeq _eSeq2, char c) {
        _eSystem.trace("print");
        System.out.print(_eSystem._lJavaString(_eSeq2));
        System.out.flush();
    }

    public void printStdErr(_eSeq _eSeq2, char c) {
        _eSystem.trace("printStdErr");
        System.err.print(_eSystem._lJavaString(_eSeq2));
        System.err.flush();
    }

    public void print(char c) {
        _eSystem.trace("print");
        System.out.print(c);
        System.out.flush();
    }

    public void print(FileRef fileRef, _eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("print");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            fileRef.getFileHandle().writeBytes(_eSystem._lJavaString(_eSeq2));
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void print(FileRef fileRef, char c, FileError fileError) {
        _eSystem.trace("print");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            fileRef.getFileHandle().writeBytes(new Character(c).toString());
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void write(FileRef fileRef, _eSeq _eSeq2, byte by, FileError fileError) {
        _eSystem.trace("write");
        if (_eSystem.enablePre && (fileRef.IsNullHandle() || !fileRef.fileWritable())) {
            throw new _xPre("1121,13");
        }
        int n = _eSeq2._oHash();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = ((_eWrapper_byte)_eSeq2._oIndex((int)i)).value;
        }
        try {
            fileRef.getFileHandle().write(byArray);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void write(FileRef fileRef, int n, int n2, FileError fileError) {
        _eSystem.trace("write");
        if (_eSystem.enablePre && (0 >= n2 || fileRef.IsNullHandle())) {
            throw new _xPre("17,22");
        }
        byte[] byArray = this.genEightBitSeq(n, n2);
        try {
            fileRef.getFileHandle().write(byArray);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void write(FileRef fileRef, int n, FileError fileError) {
        _eSystem.trace("write");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            fileRef.getFileHandle().writeInt(n);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void write(FileRef fileRef, double d, FileError fileError) {
        _eSystem.trace("write");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            fileRef.getFileHandle().writeDouble(d);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void write(FileRef fileRef, byte by, FileError fileError) {
        _eSystem.trace("write");
        if (_eSystem.enablePre && (fileRef.IsNullHandle() || !fileRef.fileWritable())) {
            throw new _xPre("1158,13");
        }
        try {
            fileRef.getFileHandle().write(by);
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 7;
        }
    }

    public void scan(FileRef fileRef, _eWrapper__eAny _eWrapper__eAny2, _eSeq _eSeq2, char c, int n, FileError fileError) {
        _eSystem.trace("scan");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        if (!fileRef.fileReadable()) {
            fileError.value = 11;
            return;
        }
        byte[] byArray = new byte[n];
        try {
            fileRef.getFileHandle().readFully(byArray, 0, n);
        }
        catch (EOFException eOFException) {
            fileError.value = 1;
            return;
        }
        catch (IOException iOException) {
            fileError.value = 6;
            return;
        }
        try {
            String string = new String(byArray, "ISO-8859-1");
            _eWrapper__eAny2.value = _eSystem._lString(string);
            fileError.value = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            fileError.value = 16;
        }
    }

    public void scan(FileRef fileRef, _eWrapper_char _eWrapper_char2, FileError fileError) {
        int n;
        _eSystem.trace("scan");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        if (!fileRef.fileReadable()) {
            fileError.value = 11;
            return;
        }
        try {
            n = fileRef.getFileHandle().read();
        }
        catch (IOException iOException) {
            fileError.value = 6;
            return;
        }
        if (n == -1) {
            fileError.value = 1;
        } else {
            fileError.value = 0;
            _eWrapper_char2.value = (char)n;
        }
    }

    public void read(FileRef fileRef, _eWrapper__eAny _eWrapper__eAny2, _eSeq _eSeq2, byte by, int n, FileError fileError) {
        _eSystem.trace("read");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        if (!fileRef.fileReadable()) {
            fileError.value = 11;
            return;
        }
        byte[] byArray = new byte[n];
        try {
            fileRef.getFileHandle().readFully(byArray);
        }
        catch (EOFException eOFException) {
            fileError.value = 1;
            return;
        }
        catch (IOException iOException) {
            fileError.value = 6;
            return;
        }
        _eSeq _eSeq3 = new _eSeq();
        for (int i = 0; i < n; ++i) {
            _eSeq3 = _eSeq3.append(new _eWrapper_byte(byArray[i]));
        }
        _eWrapper__eAny2.value = _eSeq3;
        fileError.value = 0;
    }

    public void read(FileRef fileRef, _eWrapper_int _eWrapper_int2, int n, FileError fileError) {
        int n2;
        _eSystem.trace("read");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        if (!fileRef.fileReadable()) {
            fileError.value = 11;
            return;
        }
        byte[] byArray = new byte[n];
        try {
            n2 = fileRef.getFileHandle().read(byArray);
        }
        catch (IOException iOException) {
            fileError.value = 6;
            return;
        }
        if (n2 == n) {
            fileError.value = 0;
            _eWrapper_int2.value = this.assembleEightBitSeq(byArray, n);
        } else {
            fileError.value = 6;
        }
    }

    public void read(FileRef fileRef, _eWrapper_int _eWrapper_int2, FileError fileError) {
        _eSystem.trace("read");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            _eWrapper_int2.value = fileRef.getFileHandle().readInt();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 6;
        }
    }

    public void read(FileRef fileRef, _eWrapper_real _eWrapper_real2, FileError fileError) {
        _eSystem.trace("read");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            _eWrapper_real2.value = fileRef.getFileHandle().readDouble();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 6;
        }
    }

    public void read(FileRef fileRef, _eWrapper_byte _eWrapper_byte2, FileError fileError) {
        _eSystem.trace("read");
        if (_eSystem.enablePre && fileRef.IsNullHandle()) {
            throw new _xPre("0,0");
        }
        try {
            _eWrapper_byte2.value = (byte)fileRef.getFileHandle().read();
            fileError.value = 0;
        }
        catch (IOException iOException) {
            fileError.value = 6;
        }
    }

    public _eSeq getImagePath() {
        _eSystem.trace("getImagePath");
        return _eSystem._lString(this.sPathname);
    }

    public FilePath normalizeFile(_eSeq _eSeq2, char c, _eSeq _eSeq3, char c2) {
        _eSystem.trace("normalizeFile");
        if (_eSystem.enablePre && _eSeq2._oHash() != 0 && Environment.pathSeparator() != ((_eWrapper_char)_eSeq2.last()).value) {
            throw new _xPre("0,0");
        }
        try {
            Object object;
            UsefulFile usefulFile;
            String string;
            String string2 = _eSystem._lJavaString(_eSeq2);
            String string3 = _eSystem._lJavaString(_eSeq3);
            String string4 = File.separator;
            String string5 = string2.startsWith(string4) && !string2.startsWith(string4.concat(string4)) ? new File(string4).getCanonicalPath().concat(string2.substring(1)) : (string2.startsWith(".".concat(string4)) ? new File(".").getCanonicalPath().concat(string2.substring(1)) : (string = !string2.startsWith(string4) && (string2.length() < 3 || string2.charAt(1) != ':' || string2.charAt(2) != '\\') ? new File(".").getCanonicalPath().concat(string4).concat(string2) : string2));
            if (string3.length() >= 2 && string3.charAt(0) == '\\' && string3.charAt(1) == '\\' || string3.length() >= 3 && string3.charAt(1) == ':' && string3.charAt(2) == '\\') {
                usefulFile = new UsefulFile(string3);
            } else if (string3.length() >= 1 && string3.charAt(0) == File.separatorChar) {
                usefulFile = new UsefulFile(new File(string4).getCanonicalPath().concat(string3.substring(1)));
            } else {
                object = new File(string);
                usefulFile = new UsefulFile((File)object, _eSystem._lJavaString(_eSeq3));
            }
            object = usefulFile.getResolvedUsefulFile().getParent();
            String string6 = object == null ? "" : (!((String)object).endsWith(string4) ? ((String)object).concat(string4) : object);
            return new FilePath(_eSystem._lString(string6), '\u0000', _eSystem._lString(usefulFile.getName()), '\u0000');
        }
        catch (IOException iOException) {
            return null;
        }
        catch (UsefulFileException usefulFileException) {
            return null;
        }
    }

    public _eSeq getCurrentDirectory() {
        _eSystem.trace("getCurrentDirectory");
        try {
            String string = System.getProperty("user.dir");
            return _eSystem._lString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setCurrentDirectory(_eSeq _eSeq2, char c, FileError fileError) {
        _eSystem.trace("setCurrentDirectory");
        String string = _eSystem._lJavaString(_eSeq2);
        try {
            System.setProperty("user.dir", string);
            fileError = new FileError(0);
        }
        catch (Exception exception) {
            File file = new File(string);
            fileError = new FileError(!file.isDirectory() ? 3 : 13);
        }
    }

    public static boolean caseSensitiveFileNames() {
        _eSystem.trace("caseSensitiveFileNames");
        return !new File("a").equals(new File("A"));
    }

    public static char pathSeparator() {
        _eSystem.trace("pathSeparator");
        return File.separatorChar;
    }

    public void setCurrentThreadPriority(int n) {
        Object object;
        _eSystem.trace("setCurrentThreadPriority");
        if (_eSystem.enablePre) {
            object = new _eWrapper_int(n);
            _eSeq _eSeq2 = _eSystem._oRange(1, 20);
            boolean bl = _eSeq2._ovIn((_eAny)object);
            if (!bl) {
                throw new _xPre("0,0");
            }
        }
        object = Thread.currentThread();
        try {
            ((Thread)object).setPriority(((_eWrapper_int)_eSystem.priorityMap()._oIndex((_eAny)new _eWrapper_int((int)n))).value);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void execute(_eSeq _eSeq2, char c, _eSeq _eSeq3, _eSeq _eSeq4, char c2, FileRef fileRef, FileRef fileRef2, FileRef fileRef3, FileError fileError) {
        _eSystem.trace("execute");
        fileError.value = 16;
    }

    public int clock() {
        _eSystem.trace("clock");
        return (int)(System.currentTimeMillis() - this.startTimeMillis);
    }

    public int clocksPerSecond() {
        _eSystem.trace("clocksPerSecond");
        return 1000;
    }

    public Time getCurrentDateTime() {
        _eSystem.trace("getCurrentDateTime");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(System.currentTimeMillis()));
        return new Time(gregorianCalendar.get(13), gregorianCalendar.get(12), gregorianCalendar.get(11), ((_eWrapper_int)_eSystem.dayMap()._oIndex((_eAny)new _eWrapper_int((int)gregorianCalendar.get((int)7)))).value, gregorianCalendar.get(5), ((_eWrapper_int)_eSystem.monthMap()._oIndex((_eAny)new _eWrapper_int((int)gregorianCalendar.get((int)2)))).value, gregorianCalendar.get(1));
    }

    public _eSeq getEnvironmentVar(_eSeq _eSeq2, char c) {
        _eSystem.trace("getEnvironmentVar");
        String string = System.getProperty(_eSystem._lJavaString(_eSeq2).toUpperCase());
        if (string == null) {
            if (this.envVars == null) {
                this.obtainEnvVars();
            }
            string = this.envVars.getProperty(_eSystem._lJavaString(_eSeq2).toUpperCase());
        }
        return string == null ? null : _eSystem._lString(string);
    }

    private void obtainEnvVars() {
        this.envVars = new Properties();
        try {
            Process process = null;
            Runtime runtime = Runtime.getRuntime();
            int n = Environment.whichOStype();
            switch (n) {
                case 1: 
                case 2: {
                    process = runtime.exec("command.com /c set");
                    break;
                }
                case 3: {
                    process = runtime.exec("cmd.exe /c set");
                    break;
                }
                case 4: {
                    process = runtime.exec("/bin/sh -c set");
                    break;
                }
                case 0: {
                    process = null;
                }
            }
            if (process != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string = "";
                String string2 = "";
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n2 = (string = string + string2).indexOf(61);
                    if (n2 == -1) continue;
                    String string3 = string.substring(0, n2).toUpperCase();
                    String string4 = string.substring(n2 + 1);
                    this.envVars.setProperty(string3, string4);
                    string = "";
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int whichOStype() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows 95") > -1 || string.indexOf("windows 9x") > -1) {
            return 1;
        }
        if (string.indexOf("windows 98") > -1 || string.indexOf("windows me") > -1) {
            return 2;
        }
        if (string.indexOf("windows nt") > -1 || string.indexOf("windows 2000") > -1 || string.indexOf("windows 2003") > -1 || string.indexOf("windows xp") > -1) {
            return 3;
        }
        if (string.indexOf("linux") > -1) {
            return 4;
        }
        return 0;
    }

    public _eSeq getImageVersion() {
        return this.getImageVersion(new _eSeq(), '\u0000');
    }

    public _eSeq getImageVersion(_eSeq _eSeq2, char c) {
        _eSystem.trace("getImageVersion");
        return new _eSeq(new _eWrapper_int(0));
    }

    public int getMemoryUsed() {
        _eSystem.trace("getMemoryUsed");
        return 0;
    }

    public void garbageCollect() {
        _eSystem.trace("garbageCollect");
        System.gc();
    }

    public OsInfo getOsInfo() {
        _eSystem.trace("getOsInfo");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = System.getProperty("os.version");
        try {
            int n5 = string.indexOf(46, n);
            if (n5 != -1) {
                n2 = Integer.valueOf(string.substring(n, n5));
                n = n5 + 1;
                n5 = string.indexOf(46, n);
            }
            if (n5 != -1) {
                n3 = Integer.valueOf(string.substring(n, n5));
                n = n5 + 1;
                n5 = string.indexOf(46, n);
            }
            if (n5 != -1) {
                n4 = Integer.valueOf(string.substring(n, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new OsInfo(Environment.whichOStype(), null, n2, n3, n4, 0);
    }

    public void setMaxCheckNestLevel(int n) {
        _eSystem.trace("setMaxCheckNestLevel");
        _eSystem.maxCheckNesting = n;
    }

    public void setRuntimeOptionState(int n, boolean bl) {
        _eSystem.trace("setRuntimeOptionState");
        switch (n) {
            case 0: {
                _eSystem.enablePre = bl;
                break;
            }
            case 1: {
                _eSystem.enablePost = bl;
                break;
            }
            case 2: {
                _eSystem.enableLoopInvariant = bl;
                break;
            }
            case 3: {
                _eSystem.enableLoopDecrease = bl;
                break;
            }
            case 4: {
                _eSystem.enableSpecDecrease = bl;
                break;
            }
            case 5: {
                _eSystem.enableImpDecrease = bl;
                break;
            }
            case 6: {
                _eSystem.enableEmbeddedAssert = bl;
                break;
            }
            case 7: {
                _eSystem.enablePostAssert = bl;
                break;
            }
            case 8: {
                _eSystem.enableLastChoice = bl;
                break;
            }
            case 9: {
                _eSystem.enableClassInvariantItem = bl;
                break;
            }
            case 10: {
                _eSystem.enableConstraint = bl;
            }
        }
    }

    public void setRuntimeOptionsState(_eSet _eSet2, boolean bl) {
        _eSystem.trace("setRuntimeOptionsState");
        int n = _eSet2._oHash();
        int n2 = 0;
        while (n2 != n) {
            this.setRuntimeOptionState(((DebugType)_eSet2._oIndex((int)n2)).value, bl);
            n2 = _eSystem._oSucc(n2);
        }
    }

    public void setRuntimeOption(int n) {
        _eSystem.trace("setRuntimeOption");
        this.setRuntimeOptionState(n, true);
    }

    public void setRuntimeOptions(_eSet _eSet2, DebugType debugType) {
        _eSystem.trace("setRuntimeOptions");
        int n = _eSet2._oHash();
        int n2 = 0;
        while (n2 != n) {
            this.setRuntimeOption(((DebugType)_eSet2._oIndex((int)n2)).value);
            n2 = _eSystem._oSucc(n2);
        }
    }

    public void clrRuntimeOption(int n) {
        _eSystem.trace("clrRuntimeOption");
        this.setRuntimeOptionState(n, false);
    }

    public void clrRuntimeOptions(_eSet _eSet2, DebugType debugType) {
        _eSystem.trace("clrRuntimeOptions");
        int n = _eSet2._oHash();
        int n2 = 0;
        while (n2 != n) {
            this.clrRuntimeOption(((DebugType)_eSet2._oIndex((int)n2)).value);
            n2 = _eSystem._oSucc(n2);
        }
    }

    public void startProfiling() {
        _eSystem.trace("startProfiling");
    }

    public void profile(FileRef fileRef, FileError fileError) {
        _eSystem.trace("profile");
        fileError.value = 16;
    }
}

