// **************************************************************************
// * File:   MiscRts.cpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Miscellaneous runtime functions.								*
// **************************************************************************

//---------
// Includes
//---------

#include "Ertsys.hpp"

// Include for the real arithmetic functions
#include <cmath>

// Include for support isNaN etc.
// Note: under VS2005 this includes <cwchar>, which includes <wchar.h>, which defined struct stat,
// which clashes with parameters called stat when compiling PDTool. So we really don't want to include this in any of our header files.
#include <limits>

// Include for character categorisation functions
#include <cctype>

//-----------------------------
// Integer exponential function
//-----------------------------

_eInt _onExp(_eInt aa, _eInt bb)
{
    #if !defined(NDEBUG)
    _mBeginPre _mCheckPre (0 <= bb, "0,0");
    _mBeginPre _mCheckPre (aa != 0 || bb != 0, "0,0");
    #endif

	_eInt val = 1;
	for (; --bb >= 0; val *= aa);
	return val;
}

// Integer approx log function.
// If argument = 0, returns 0; else returns log(2) argument, rounded down to the nearest integer.
_eInt _lintln(_eInt aa)
{
    #if !defined(NDEBUG)
    _mBeginPre _mCheckPre (0 <= aa, "0,0");
    #endif
	_eInt rslt = -1;
	do
	{
		aa >>= 1;
		rslt += 1;
	} while (aa != 0);
	return rslt;
}

//---------------------------------------------
// Member functions of class "real"
//---------------------------------------------

_eInt _lroundup(const _eReal aa)
{
	return static_cast<_eInt>(std :: ceil(aa));
}

_eInt _lrounddn(const _eReal aa)
{
	return static_cast<_eInt>(std :: floor(aa));
}

_eBool _lisInfinite(const _eReal aa)
{
	return std :: numeric_limits<double> :: has_infinity
		&& (aa == std :: numeric_limits<double> :: infinity() || (-aa) == std :: numeric_limits<double> :: infinity());
}

_eReal _onExp(_eReal aa, _eReal bb)
{
	return std :: pow(aa, bb);
}

_eReal _onExp(_eInt aa, _eReal bb)
{
	return std :: pow(static_cast<_eReal>(aa), bb);
}

_eReal _onExp(_eReal aa, _eInt bb)
{
#if defined(_WIN64)
	return std :: pow(aa, static_cast<int>(bb));
#else
 	return std :: pow(aa, bb);
#endif
}

//---------------------------------------------
// Member functions of class "char"
//---------------------------------------------

#if defined(_MSC_VER)

  // Microsoft's locale support won't compile in strict ANSI mode with VC++ 6,
  // so we are forced to use the older C-type functions instead.
  // THIS WON'T WORK IF WE CHANGE TO USING WIDE CHARACTERS!

  // Temporarily disable warning C4800 (forcing int to bool)
  #pragma warning(push)
  #pragma warning(disable: 4800)
#endif

//	function isLetter name "_lisLetter": bool ^= ?;
_eBool _lisLetter(_eChar c) { return static_cast<_eBool>(isalpha(c)); }

//	function isLowerCase name "_lisLowerCase": bool ^= ?;
_eBool _lisLowerCase(_eChar c) { return static_cast<_eBool>(islower(c)); }

//	function isUpperCase name "_lisUpperCase": bool ^= ?;
_eBool _lisUpperCase(_eChar c) { return static_cast<_eBool>(isupper(c)); }

//	function isDigit name "_lisDigit": bool ^= ?;
_eBool _lisDigit(_eChar c) { return static_cast<_eBool>(isdigit(c)); }

#if defined(_MSC_VER)
  #pragma warning(pop)
#endif

//	function isPrintable name "_lisPrintable": bool ^= ?;
_eBool _lisPrintable(_eChar c) { return (static_cast<_eUnsignedChar>(c) >= 0x20 && static_cast<_eUnsignedChar>(c) <= 0x7E) || static_cast<_eUnsignedChar>(c) >=0xA0; }

//	function toLowerCase name "_ltoLowerCase": char ^= ? assert ~self.isUpperCase ==> result = self;
_eChar _ltoLowerCase(_eChar c) { return static_cast<_eChar>(tolower(c)); }

//	function toUpperCase name "_ltoUpperCase": char ^= ? assert ~self.isLowerCase ==> result = self;
_eChar _ltoUpperCase(_eChar c) { return static_cast<_eChar>(toupper(c)); }


// Byte constructor taking a sequence of bits, most significant bit first
//	build name "_lBitsToByte" {!theBits: seq of bool}
//		pre #theBits = 8;
_eByte _lBitsToByte(const _eSeq<_eBool> arg)
{
    #if !defined(NDEBUG)
    _mBeginPre _mCheckPre (arg._oHash() == 8, "0,0");
    #endif

	unsigned int rslt = 0;
	for (_eInt index = 0; index < 8; ++ index)
	{
		rslt <<= 1;
		if (arg[index])
		{
			rslt |= 1;
		}
	}
	return static_cast<_eByte>(rslt);
}

// Function to provide a way to throw exceptions from serialisation code. No value is ever returned!
// This will be replaced by a 'Perfect' exception mechanism eventually
_eBool _aThrow (const _eEselException * ex)
{
    _mFunction (_throwException);
	// We have to wrap the exception thrown (which exception is not known until runtime)
	// in some statically bound class because we cannot throw dynamically bound objects
	// (ie. we cannot say "throw *ex") ...
	throw _aEselExceptionWrapper(ex);
  #if defined(_MSC_VER) && _MSC_VER < 1400
    return true;		// to keep VC++ 6.0 happy
  #endif
}

// Class used by '_aThrow(..)' to wrap the exception into something we can throw in C++ ...
_eSeq < _eChar > _aEselExceptionWrapper :: msg () const
{
    _mFunction (msg);
    return exception -> msg;
}
//
_aExceptionId :: _eEnum _aEselExceptionWrapper :: id () const
{
    _mFunction (id);
    return exception -> id;
}
//
_aEselExceptionWrapper :: _aEselExceptionWrapper (const _eEselException * _vexception) : exception (_vexception)
{
    _mBuild;
}
//
_eBool _aEselExceptionWrapper :: operator == (const _aEselExceptionWrapper & _vEqualityArg_14_9) const
{
    _mOperator (=);
    return _vEqualityArg_14_9.exception -> _lEqual (exception.Ptr ());
}

// End.
