// **************************************************************************
// * File:   ModuleDescriptorSupport_1.hpp									*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definitions used to define and obtain the module descriptor 	*
// *         (MDx) nodes.													*
// **************************************************************************

#if !defined(_h_Main_ModuleDescriptorSupport)
#define _h_Main_ModuleDescriptorSupport 1

#include "TypeInfoSupport_1.hpp"
#include "Storable_1.hpp"

//------------------------------------------------------------------------------------------------------------
// Class '_eMDH' - the class to represent a node in the linked-list of type-name/object-creator-function pairs
//------------------------------------------------------------------------------------------------------------

class _eMDH
{
	// This typedef allows us to use 'CREAT_LDABLE_OBJFN_PTR' to refer to a pointer to a function
	// returning '_eFrom<_eStorable>' that takes '_eNat' as an argument. See Stroustrop  p.157
	typedef _eFrom<_eStorable> (*CREAT_LDABLEOBJ_FN_PTR) (const _eNat typeIndex);
	typedef _eAddress (*GET_HEAPADDR_FN_PTR) (const _eNat heapIndex);
	// Pointer to the next node in the list
	_eMDH* next;
	// The MDH data item for this node (this holds the type, instantiation and heap entries for the module represented by this node)
	_eHndl<_eModuleDescriptorData> moduleData;
	// this piece of data is redeundant, but included so we can say things about the list in generated runtime loop variants
	_eNat nodeIndex;
  public:
	// Pointer to root node (the last one added) - initialized to NULL by default - static so that we can
	// build instances of _eMDH and have them automatically link together - magic eh?!
	static _eMDH* root;
	// pointers to the functions that create the various objects referred to in the tables inside moduleData
	CREAT_LDABLEOBJ_FN_PTR createRegrLoadableObjFn;
	CREAT_LDABLEOBJ_FN_PTR createTmplLoadableObjFn;
	GET_HEAPADDR_FN_PTR getHeapAddressFn;

	_eNat getMDHnodeIndex() const { return nodeIndex; }
	_eHndl<_eModuleDescriptorData> getModuleData() const { return moduleData; }
	_eMDH* getNextNode() const { return next; }

	// Constructor - called automatically upon initialization of the static _eMDH node that is
	// generated for each 'Perfect' file containing storable types ...
	_eMDH( _eHndl<_eModuleDescriptorData> modData,
		   CREAT_LDABLEOBJ_FN_PTR createRegrObjectFn,
		   CREAT_LDABLEOBJ_FN_PTR createTmplObjectFn,
		   GET_HEAPADDR_FN_PTR getHeapAddrFn )
		: moduleData(modData),
		  createRegrLoadableObjFn(createRegrObjectFn),
		  createTmplLoadableObjFn(createTmplObjectFn),
		  getHeapAddressFn(getHeapAddrFn)
	{
		nodeIndex = (root == NULL ? 0 : ++(root->nodeIndex));		// the 'root' node always has the highest index in the list
		next = root;
		root = this;
	}
};

//-----------------------------------------------------
// Class to represent a Module Descriptor Header (node)
//-----------------------------------------------------

class _eModuleDescriptorAddress
{
	_eMDH* nodePtr;		// the pointer to the actual MDH node represented by this MDA instance
  public:
    // FINAL DIRECT class ...
    _mNew (_eModuleDescriptorAddress)
    _eBool valid() const;
	_eNat getMDHnodeIndex() const;
	_eHndl <_eModuleDescriptorData> getMDdata() const;
    _eFrom <_eStorable> templateInstantiate(const _eNat) const;
    _eFrom <_eStorable> regtypeInstantiate(const _eNat) const;
    _eAddress obtainHeapAddress (const _eNat) const;
    _eBool existMDlistNext() const;
    _eModuleDescriptorAddress getMDlistNext() const;
    _eModuleDescriptorAddress(const _eMDH* ptr);
	_eModuleDescriptorAddress();
    _eBool operator == (const _eModuleDescriptorAddress &) const;
	_eRank :: _eEnum _oRank (const _eModuleDescriptorAddress & other) const
	{
    	return ((nodePtr > other.nodePtr) ? _eRank :: above : (nodePtr < other.nodePtr) ? _eRank :: below : _eRank :: same);
	}
};

inline _eRank :: _eEnum _onRank(const _eModuleDescriptorAddress& arg1, const _eModuleDescriptorAddress& arg2)
{
	return arg1._oRank(arg2);
}

//------------------------------------------------------------------------------------
// Function to obtain the head node of the system-wide Module Descriptor Header (MDH)
// list. We use this to traverse the MDH list during searches
//------------------------------------------------------------------------------------

extern _eModuleDescriptorAddress _agetMDlistHead ();

//--------------------------------------------------------------------------------
// Definitions required for the MDA constant that describes the builtin types
//--------------------------------------------------------------------------------

// The indices of the basic type entries in the TypeTable part of the MDD. Note that there MUST be corrosponding
// entries in the builtin '_amoduleData' table (see ModuleDescriptorSupport.cpp) in the SAME ORDER for each of
// the enumerations defined here
namespace _estcBasicTypeCode
{	enum _eEnum
	{	// small classes in the runtime system ...
		BUILTIN_TYPEIDX_INT, BUILTIN_TYPEIDX_BOOL, BUILTIN_TYPEIDX_CHAR, BUILTIN_TYPEIDX_REAL,
		BUILTIN_TYPEIDX_BYTE, BUILTIN_TYPEIDX_RANK,
		BUILTIN_TYPEIDX_SEQ, BUILTIN_TYPEIDX_SET, BUILTIN_TYPEIDX_BAG,
		BUILTIN_TYPEIDX_MAP, BUILTIN_TYPEIDX_PAIR, BUILTIN_TYPEIDX_TRIPLE,
		BUILTIN_TYPEIDX_MULTIPLE2, BUILTIN_TYPEIDX_MULTIPLE3, BUILTIN_TYPEIDX_MULTIPLE4,
		BUILTIN_TYPEIDX_REF,
		BUILTIN_TYPEIDX_UNION,
		// enums that can't be written in Perfect (due to their position in the include order)
		BUILTIN_TYPEIDX_ENUM_EXCEPTIONID,
		BUILTIN_TYPEIDX_ENUM_COMPLEXVALUE,
		// handle classes that can't be written in Perfect
		BUILTIN_TYPEIDX_ENVIRONMENT,
		BUILTIN_TYPEIDX_SOCKET,
		BUILTIN_TYPEIDX_FILEREF,
		BUILTIN_TYPEIDX_LOWLEVELSUPPORT,
		// other nasty stuff ...
		BUILTIN_TYPEIDX_ANYBASE,
		BUILTIN_TYPEIDX_EADDRESS
	};
	// Only the unary + operator is required on this enumeration
	inline _eInt _onPlus(const _eEnum x)
		{	return static_cast<_eInt>(x);	}
}

// The MDA constant itself
extern _eModuleDescriptorAddress _ebuiltinTypeTable();

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
