// **************************************************************************
// * File:   LowLevelSupport_1.hpp											*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement low-level interface to the local OS			*
// *         environment (ie. the local filesystem). All primitives used in *
// *         the code are POSIX complient, and where necessary we provide	*
// *         macros to vendor specific calls.								*
// **************************************************************************


#if !defined(_hMain_LowLevelSupport)
#define _hMain_LowLevelSupport

// Full declarations

class _eLowLevelSupport : public _eAny
{
public:
    // CONCRETE INDIRECT class ...
    _mDefineType (_eLowLevelSupport)
    _mDefineCopy (_eLowLevelSupport)
    _mEqualsOperator (_eLowLevelSupport)
    _mPerfectTypeInfoHdrNA(_eLowLevelSupport)
    _mNew (_eLowLevelSupport)
public:
    static void mkdircomp (const _eSeq < _eChar >, FileError :: _eEnum &);

	static _eInt maskNat (const _eInt num, const _eInt mask)
	{
    	return num & mask;
	}

	static _eInt shrtNat (const _eInt num, const _eInt numBits)
	{
    	return num >> numBits;
	}

	static _eInt lgorNat (const _eInt num, const _eInt mask)
	{
    	return num | mask;
	}

    static _eInt shltNat (const _eInt num, const _eInt numBits)
	{
    	return num << numBits;
	}

	static _eInt lxorNat (const _eInt num, const _eInt mask)
	{
    	return num ^ mask;
	}

    static _eSeq < _eByte > intToBytes (const _eInt, _eNat);
	static _eInt bytesToInt (const _eSeq < _eByte >);

    static _eSeq < _eByte > realToBytes (const _eReal);
	static _eReal bytesToReal (const _eSeq < _eByte >);

//	static int doSignExtend(int n, int numBytes);	// used by the multi-byte-integer 'read(..)' environment schema

	_eBool operator == (const _eLowLevelSupport *) const;
};

#endif

// End of file.
