// Method bodies for class _eHndl<X>
// Sepearated from file From.hpp for full ANSI compliance
// D. Crocker, 2009-05-17

#if ! defined (_hInline_Handle)
#define _hInline_Handle

template <class X> void _eHndl<X> :: _afill(_eFillStream* stream)
{
	// generate an object of the correct type
	_eFrom<_eStorable> temp;
	stream -> _afillAllowNull(temp);
	// pull out the pointer in the filled handle
	Object = const_cast<_eAnyBase*>(static_cast<const _eAnyBase*>(temp.Ptr()));
	if (Object != NULL && !_mWithin(Object, X))		// do a quick type-check on the de-serialized object
	{
		_athrowStorageException(_mCstr("Unexpected handle-type found in storage stream (exact-type)"), _aExceptionId :: eSsUnexpectedType);
	}
	// the object's use-count will get decremented when 'temp' goes out of scope, so need to bump it
	AddLink();
}

#endif

// End
