// Method bodies for class _eFrom<X>
// Sepearated from file From.hpp for full ANSI compliance
// D. Crocker, 2009-05-17

#if ! defined (_hInline_From)
#define _hInline_From

template <class X> void _eFrom<X> :: _afill(_eFillStream* stream)
{
	// generate an object of the correct type
	_eFrom<_eStorable> temp;
	stream -> _afillAllowNull(temp);
	// pull out the pointer in the filled handle
	Object = const_cast<_eAnyBase*>(static_cast<const _eAnyBase*>(temp.Ptr()));
	if (Object != NULL && !_mWithinFrom(Object, X))		// do a quick type-check on the de-serialized object
	{
		_athrowStorageException(_mCstr("Unexpected handle-type found in storage stream (from-type)"), _aExceptionId :: eSsUnexpectedType);
	}
	// the object's use-count will get decremented when 'temp' goes out of scope, so need to bump it
	AddLink();
}

template <class X> _eHndl<_eInstblTypeInfo> _eFrom<X> :: _aMyTypeInfo()
{
	_eHndl<_eInstblTypeInfo> temp = X :: _aMyTypeInfo();
	temp.Change().setFromAndRefFields(true, false);
	return temp;
}

#endif

// End
