// **************************************************************************
// * File:   EarlyMisc.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Miscellaneous runtime functions that are required before the	*
// *         definition of built in collections.							*
// **************************************************************************

#if !defined(_h_EarlyMisc)
#define _h_EarlyMisc 1

// Special type used as the type of the dummy parameter for constrcuting skeletel objects when
// loading objects (ie. when de-serializing)
class _aEmptyClass
{
};

// Representation of the constant we use as the dummy parameter passed to the special
// constructors of storable classes during the 'fill' process ...
extern _aEmptyClass _adummyParam();

//----------------------------------------------------
// Support macros for (de)serializing enumerations
//----------------------------------------------------

#define _mEnumStorableSupportHdr(_Name)												\
	extern void _astoreGlobal(_eStoreStream* stream, const _Name :: _eEnum item);	\
	extern void _afillGlobal(_eFillStream* stream, _Name :: _eEnum & item);			\
	inline _eComplexValue :: _eEnum _agetFixedCode(const _Name :: _eEnum & item)	\
	{ return _eComplexValue :: CV_RSVD; }

// We pass the sourcename an the finalname of the (potentially named) enum here, because the type tables
// store sourceId's but the store functions must use the finalId's, ie. the names of the enum types actually generated
#define _mEnumStorableSupportBdy(_FinalName, _SourceName)						\
	void _astoreGlobal(_eStoreStream* stream, const _FinalName :: _eEnum item)	\
	{																			\
		stream->_astoreEnum(_mString(#_SourceName), +item);						\
	}																			\
	void _afillGlobal(_eFillStream* stream, _FinalName :: _eEnum & item)		\
	{																			\
		_eNat temp;																\
		stream->_afillEnum(_mString(#_SourceName), temp);						\
		item = static_cast<_FinalName :: _eEnum>(temp);							\
	}

// Constants used to indicate the kind of ComplexValue (see the grammar document for details)
namespace _eComplexValue
{	enum _eEnum
	{	CV_RSVD,		// Does nothing except take up enum = 0
		CV_SYSSTR,		// System string, used for magic
		CV_REP,
		CV_NULL,
		CV_END,
		CV_HNDL,
		CV_ANOTHERHNDL,
		CV_SMALL,
		CV_REF,
		CV_ANOTHERREF,
		CV_UNION,
		CV_COLLECTION,
		CV_ENUM_1,		// Single byte enum
		CV_ENUM_2,
		CV_ENUM_4,
		CV_INT_0,       // Zero byte int - ie. integer value 0
		CV_INT_1,       // Single byte int
		CV_INT_2,
		CV_INT_4,
		CV_INT_8,
		CV_INT_L,		// Large (variable precision) int
		CV_CHAR,
		CV_BOOL,
		CV_REAL,
		CV_DOUBLE,
		CV_DCL_HEAP,
		CV_DCL_STYPE,
		CV_DCL_TTYPE,
		CV_DCL_INSTN,
		CV_BYTE
	};
    extern const _eNativeChar* _lnaming[30];
}

// Storage exception ID's ...
namespace _aExceptionId
{	enum _eEnum
	{	eSsWriteError,
		eSsInternalError,
		eSsReadError,
		eSsMissingInstantiation,		// thrown by the 'instantiate function in class TypeInfo
		eSsMissingHeap,
		eSsMissingType,					// thrown by the CTOR in 'InstblTypeInfo'
		eSsUnexpectedType,
		eSsInvalidCvCode,				// thrown by schema readCVcode during de-serialization
		eSsCorruptStream
	};
    extern const _eNativeChar* _lnaming[3];
}

// Function to allow us to throw storage-exceptions from the low-level classes (_eHandle and _eFrom)
void _athrowStorageException(const _eNativeChar *msg, const _aExceptionId :: _eEnum id);

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
