/*-------------------------------------------------------*/
/* File:    C:/Escher/Examples/ecv/bsearch.h             */
/* Author:  David Crocker                                */
/* Created: 10:04:53 on Monday December 13th 2010 UTC    */
/*-------------------------------------------------------*/

#include "stddef.h"		/* for size_t */

typedef double elem_t;

/* Search a table of ordered elements of elem_t for the nearest match to 'key' */
size_t bsearch(const elem_t* array table, size_t numElems, elem_t key)
pre(table.lim >= numElems)
pre(forall i in 0..(numElems - 1); j in 0..(numElems - 1) :- i < j => table[i] < table[j])	/* table elements are in strictly increasing order */
post(result <= numElems)									/* result is either a valid index into the table or is equal to numElems */
post(result == 0 || table[result - 1] < key)				/* the table element just before 'result' is < key */
post(result == numElems || key <= table[result])			/* the table element at 'result' (if it isn't the end of the table) is >= key */
;

/* End */
