/* File wchar.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_wchar_h_included__)
#define __ecv_wchar_h_included__

#pragma ECV noverify

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* No need to define wchar_t because eCv treats it as a builtin type */

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
#     define __ecv_size_t_defined__
#   endif
# endif

# if !defined(__ecv_wint_t_defined__)
#   define __ecv_wint_t_defined__
#   if __ECV_WCHAR_UNSIGNED__
	  typedef unsigned int wint_t;
#   else
	  typedef int wint_t;
#   endif
	  typedef int wctype_t;
# endif

typedef struct { int dummy; } mbstate_t;

struct tm;

# if !defined _ecv_file_defined
#  define _ecv_file_defined
typedef struct { int dummy; } FILE;
# endif

# if !defined(_ecv_va_list_defined)
#  define _ecv_va_list_defined
typedef struct { const void* _ecv_null p; unsigned int s; } va_list;
# endif

/* Define the NULL macro */

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

# if __ECV_WCHAR_UNSIGNED__
#   define WCHAR_MIN	((wchar_t) 0u)
#   define WCHAR_MAX	((wchar_t)((1u << __ECV_WCHAR_BITS__) - 1u))
#   if !defined(WEOF)
#     define WEOF		((wint_t) ((1u << __ECV_WCHAR_BITS__) - 1u))
#   endif
# else
#   define WCHAR_MIN	((wchar_t)(-(1u << (__ECV_WCHAR_BITS__ - 1u))     ))
#   define WCHAR_MAX	((wchar_t)( (1u << (__ECV_WCHAR_BITS__ - 1u)) - 1u))
#   if !defined(WEOF)
#     define WEOF		((wint_t) (-1))
#   endif
# endif

extern FILE _ecv_files[];
# define stdin			(&_ecv_files[0])
# define stdout			(&_ecv_files[1])
# define stderr			(&_ecv_files[2])

int fwprintf(FILE* _ecv_restrict stream, const wchar_t* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stream);
int fwscanf(FILE* _ecv_restrict stream, const wchar_t* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stream);
int swprintf(wchar_t* _ecv_array _ecv_restrict s, size_t n, const wchar_t* _ecv_array _ecv_restrict format, ...) _ecv_writes(s.all);
int swscanf(const wchar_t* _ecv_array _ecv_restrict s, const wchar_t* _ecv_array _ecv_restrict format, ...);
int vfwprintf(FILE* _ecv_restrict stream, const wchar_t* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stream);
int vfwscanf(FILE* _ecv_restrict stream, const wchar_t* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stream);
int vswprintf(wchar_t* _ecv_array _ecv_restrict s, size_t n, const wchar_t* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(s.all);
int vswscanf(const wchar_t* _ecv_array _ecv_restrict s, const wchar_t* _ecv_array _ecv_restrict format, va_list arg);
int vwprintf(const wchar_t* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stdout);
int vwscanf(const wchar_t* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stdin);
int wprintf(const wchar_t* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stdout);
int wscanf(const wchar_t* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stdin);
wint_t fgetwc(FILE* stream) _ecv_writes(*stream);
wchar_t* _ecv_array fgetws(wchar_t* _ecv_array _ecv_restrict s, int n, FILE* _ecv_restrict stream) _ecv_writes(s.all; *stream);
wint_t fputwc(wchar_t c, FILE* stream) _ecv_writes(*stream);
int fputws(const wchar_t* _ecv_array _ecv_restrict s, FILE* _ecv_restrict stream) _ecv_writes(*stream);
int fwide(FILE* stream, int mode) _ecv_writes(*stream);
wint_t getwc(FILE* stream) _ecv_writes(*stream);
wint_t getwchar(void) _ecv_writes(*stdin);
wint_t putwc(wchar_t c, FILE* stream) _ecv_writes(*stream);
wint_t putwchar(wchar_t c) _ecv_writes(*stdout);
wint_t ungetwc(wint_t c, FILE* stream) _ecv_writes(*stream);

double wcstod					(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
float wcstof					(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
long double wcstold				(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
long int wcstol					(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
unsigned long int wcstoul		(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));

# if (defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)) || (defined(__cplusplus) && (__cplusplus >= 201103L))
long long int wcstoll			(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
unsigned long long int wcstoull	(const wchar_t* _ecv_array _ecv_restrict nptr, wchar_t* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
# endif


wchar_t *wcscpy(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2) _ecv_writes(s1.all);
wchar_t *wcsncpy(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2, size_t n) _ecv_writes(s1.all);
wchar_t *wcscat(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2) _ecv_writes(s1.all);
wchar_t *wcsncat(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2, size_t n) _ecv_writes(s1.all);

int wcscmp(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
int wcscoll(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
int wcsncmp(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2, size_t n);

size_t wcsxfrm(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2, size_t n) _ecv_writes(s1.all);
wchar_t *wcschr(const wchar_t* _ecv_array s, wchar_t c);
size_t wcscspn(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
wchar_t *wcspbrk(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
wchar_t *wcsrchr(const wchar_t* _ecv_array s, wchar_t c);
size_t wcsspn(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
wchar_t *wcsstr(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2);
wchar_t *wcstok(wchar_t* _ecv_array _ecv_null _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2, wchar_t* _ecv_array * _ecv_restrict ptr) _ecv_writes(_ecv_not_null(s1).all; *ptr);
size_t wcslen(const wchar_t*_ecv_array s);

wchar_t *wmemcpy(wchar_t* _ecv_array _ecv_restrict s1, const wchar_t* _ecv_array _ecv_restrict s2, size_t n) _ecv_writes(s1.all);
wchar_t *wmemmove(wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2, size_t n) _ecv_writes(s1.all);
int wmemcmp(const wchar_t* _ecv_array s1, const wchar_t* _ecv_array s2, size_t n);
wchar_t *wmemchr(const wchar_t* _ecv_array s, wchar_t c, size_t n);
wchar_t *wmemset(wchar_t* _ecv_array s, wchar_t c, size_t n) _ecv_writes(s.all);

wint_t btowc(int c);
int wctob(wint_t c);

int mbsinit(const mbstate_t* ps);

size_t mbrlen(const char* _ecv_array _ecv_restrict s, size_t n, mbstate_t* _ecv_restrict ps) _ecv_writes(*ps);
size_t mbrtowc(wchar_t* _ecv_array _ecv_null _ecv_restrict pwc, const char* _ecv_array _ecv_null _ecv_restrict s, size_t n, mbstate_t* _ecv_restrict ps) _ecv_writes(_ecv_not_null(pwc).all; *ps);
size_t wcrtomb(char* _ecv_array _ecv_null _ecv_restrict s, wchar_t wc, mbstate_t* _ecv_restrict ps) _ecv_writes(_ecv_not_null(s).all; *ps);
size_t mbsrtowcs(wchar_t* _ecv_array _ecv_null _ecv_restrict dst, const char* _ecv_array _ecv_null * _ecv_restrict src, size_t len, mbstate_t* _ecv_restrict ps) _ecv_writes(_ecv_not_null(dst).all; *src; *ps);
size_t wcsrtombs(char* _ecv_array _ecv_null _ecv_restrict dst, const wchar_t* _ecv_array _ecv_null * _ecv_restrict src, size_t len, mbstate_t* _ecv_restrict ps) _ecv_writes(_ecv_not_null(dst).all; *src; *ps);

#else
# error "Missing macro definitions! Use this include file only when running Escher C verifier."
#endif

#endif

/* End */
