/* File stddef.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_stddef_h_included__)
#define __ecv_stddef_h_included__

#pragma ECV noverify

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* Define size_t and ptrdiff_t. We assume that size_t should be defined as an unsigned integral type just long enough to contain a pointer. */

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
	  typedef int ptrdiff_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
	  typedef long int ptrdiff_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
	  typedef long long int ptrdiff_t;
#     define __ecv_size_t_defined__
#   endif
# endif

/* Define the NULL macro */

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

/* We don't need to define wchar_t because eCv treats it as a separate built-in type */

/* Note: the 'offsetof' macro isn't supported by eCv or permitted by MISRA C 2004! */
#define offsetof(_type, _member)	(reinterpret_cast<const char* _ecv_array>(&((reinterpret_cast<_type*>(8))->_member)) - reinterpret_cast<const char* _ecv_array>(reinterpret_cast<_type*>(8)))

#else
# error "Missing macro definitions!. Use this include file only when running Escher C verifier."
#endif

#endif

/* End */
