// **************************************************************************
// * File:   ExceptionClasses.cpp								   			*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Exception definitions, exception message formatting code and	*
// *         exception macro definitions.									*
// **************************************************************************

//---------
// Includes
//---------

#include "Ertsys.hpp"
#include "CharHelpers.hpp"
#include <cwchar>
#include <cstdlib>

//--------------
// _eFormat code
//--------------

void _eFormat::append(_eWorkspace pchar, _eCstr cs, _eSize& size) const
{
	// Safely adds cs to the end of buffer pchar. Updates
	// pchar and reduces size by length of cs.
	while((size > 0) && (*cs != 0))
	{
		*pchar = *cs;
		++pchar, ++cs, --size;
	}
	*pchar = '\0';
}

void _eFormat::append(_eWorkspace pchar, _eInt i, _eSize& size) const
{
	_eNativeChar number[_lDigitsMax + 1];
	_mSnprintf(number, _lDigitsMax + 1, L"%d", i);
	append(pchar, number, size);
}

//---------------
// _xCeption code
//---------------

_xCeption :: _xCeption(_eCstr file, _eNat line)
#if _dCppInfo
	: cppInfo(file, line)
#endif
{
	// If running a debug version built using Visual C++, break into the debugger
  	#if defined(_MSC_VER) && !defined(_WIN64)
		__asm { int 3 }
	#endif

   	_eCallStack const * currentptr = _eEscherRuntime::threadCallStack;
	for (unsigned int counter = 0; counter < _eEscherRuntime::maxStackOutput; ++counter)
	{
		if (currentptr == NULL)
		{
			_eEscherRuntime::stringArray[counter] = NULL;
		}
		else
		{
        	// Store this stack entry & move onto the next one...
        	_eEscherRuntime::stringArray[counter] = currentptr->formattedStr();
        	currentptr = currentptr->next;
		}
	}
}

void _xCeption::getMessage(_eNativeChar* const buffer, const _eSize size) const
{
	_eNativeChar* cursor = buffer;
	_eSize space = size;

	appendHeader(cursor, space);
	appendMessage(cursor, space);
  #if _dCppInfo
	append(cursor, _mCstr("\n"), space);
	cppInfo.appendSelf(cursor, space);
  #endif
	append(cursor, _mCstr("."), space);
}

//-------------------------------------------------------------------------
// Definition of _xMemory CTOR if we have memory debugging turned on
//-------------------------------------------------------------------------

#if _dMemory

_xMemory :: _xMemory(_eCstr file, _eNat line)
	: _xCannotHappen(_mCstr("Memory allocation failed"), file, line){}

#endif

// End.
