// **************************************************************************
// * File:   SourceInfo.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definition of exception message formatting class, and the		*
// *         classes to hold declaration location information in the Perfect*
// *         source and in the target C++ code.	Also, definitions of macros	*
// *         for holding naming information about translated functions,		*
// *         operators and constructors.									*
// **************************************************************************

#if	!defined( _h_sourceinfo)
#define _h_sourceinfo

//-------------------------
// Typedefs for readability
//-------------------------

typedef _eNativeChar *& _eWorkspace;

//---------------------------------------------------------------
// Class '_eFormat' - used for formatting information for display
// in a finite buffer in an operating system-independent way.
//---------------------------------------------------------------

class _eFormat
{
  public:
	virtual void appendSelf(_eWorkspace, _eSize&) const {}
	virtual ~_eFormat() {}

  protected:
	// Use these routines to implement public 'append'
	// assumes _eWorkspace starting at pchar, stretching for size chars.
	// copies cs to pchar; pchar increased and size decreased accordingly.
	void append(_eWorkspace pchar, _eCstr cs, _eSize& size) const;
	void append(_eWorkspace pchar, _eInt cs, _eSize& size) const;
};

//-------------------------------------------------------------
// Class to hold source code location information/naming-macros
//---------------------------------=======---------------------

#if _dCallStack
  // Class to hold information about 'Perfect' source location...
  class _eCallStackInfo : public _eFormat
  {
    public:
	  // source code co-ordinates
	  _eCallStackInfo(_eCstr name, _eCstr positionInfo)
	    : functionName(name), locationData(positionInfo) {}

	  void appendSelf(_eWorkspace buf, _eSize& size) const
	  {
		append(buf, _mCstr("class/function = "), size);
		append(buf, functionName, size);
		append(buf, _mCstr("; position = ("), size);
		append(buf, locationData, size);
		append(buf, _mCstr(")"), size);
	  }

	  _eCstr functionName;

    protected:
	  // source code location data (as a formatted string)
	  _eCstr locationData;
  };
#endif

//----------------------------------------------
// Class to hold target C++ location information
//----------------------------------------------

#if _dCppInfo

  class _eCppInfo : public _eFormat
  {
    public:
	  // C++ source code information
	  _eCppInfo(_eCstr file, _eNat line)
	    : File(file), Line(line) {}

	  void appendSelf(_eWorkspace buf, _eSize& size) const
	  {
		append(buf, _mCstr("C++ source code: file = "), size);
		append(buf, File, size);
		append(buf, _mCstr("; line = "), size);
		append(buf, Line, size);
	  }

	  ~_eCppInfo(){}
    protected:
	  // C++ source code co-ordinates
	  _eCstr File;
	  _eNat Line;
  };

#endif

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
