// **************************************************************************
// * File:   Ertsys.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Main C++ runtime system include file.							*
// * Notes:  The order that runtime files are included is critical,			*
// *         hence the complex tri-phase mechanism. The include order 		*
// *         should not be changed under any circumstances.					*
// **************************************************************************

#if !defined(_h_Ertsys)
#define _h_Ertsys

#define _dUnicode		(1)			// use Unicode character set instead of ASCII

//--------------------------------------
// Include for type namings (_eBool etc)
//--------------------------------------

#include "Types.hpp"

//-----------------------------
// Common runtime include files
//-----------------------------

#include "Pragmas.hpp"
#include "RuntimeVars.hpp"
#include "MiscMacs.hpp"
#include "Swap.hpp"
#include "Order.hpp"
#include "Emem.hpp"
#include "Dmacro.hpp"
#include "CallStack.hpp"
#include "StorageStream_0.hpp"
#include "AnyBase.hpp"
#include "SourceInfo.hpp"
#include "ExceptionBase.hpp"
#include "ExceptionClasses.hpp"
#include "ClassMacros.hpp"
#include "BaseHandle.hpp"
#include "TypeInfo_0.hpp"
#include "EarlyMisc.hpp"
#include "Casts.hpp"
#include "Storable_0.hpp"
#include "Handle.hpp"
#include "From.hpp"
#include "Multiple_0.hpp"
#include "Multiple_1.hpp"
#include "Vectors_0.hpp"
#include "Vectors_1.hpp"
#include "Variants.hpp"
#include "LoadableSupport_0.hpp"

//------------------------------------
// Includes for the collection classes
//------------------------------------

#include "Comparator_0.hpp"
#include "Sequence_0.hpp"
#include "Set_0.hpp"
#include "Bag_0.hpp"
#include "Pair_0.hpp"
#include "Map_0.hpp"

#include "Comparator_1.hpp"
#include "Sequence_1.hpp"
#include "Set_1.hpp"
#include "Bag_1.hpp"
#include "Pair_1.hpp"
#include "Map_1.hpp"

//--------------------------
// Some more common includes
//--------------------------

#include "String.hpp"
#include "Any.hpp"
#include "Union_0.hpp"
#include "Union_1.hpp"
#include "MiscRts.hpp"
#include "CharEncoding_0.hpp"
#include "CharEncoding_1.hpp"
#include "Heaps.hpp"
#include "EnvironmentSupport_0.hpp"
#include "Environment_0.hpp"
#include "StorageStream_1.hpp"
#include "StreamClasses_1.hpp"
#include "Wrappers.hpp"
#include "EnvironmentSupport_1.hpp"
#include "Environment_1.hpp"
#include "Sockets.hpp"
#include "Storable_1.hpp"
#include "TypeInfoSupport_0.hpp"
#include "ModuleDescriptorSupport_1.hpp"
#include "Debug.hpp"
#include "RtsGlobals_0.hpp"
#include "RtsGlobals_1.hpp"
#include "LoadableSupport_1.hpp"
#include "TemplateTypeMatcher_0.hpp"
#include "TemplateTypeMatcher_1.hpp"
#include "ObjectLoader_0.hpp"
#include "ObjectLoader_1.hpp"
#include "Throw.hpp"

// Inline code includes (shouldn't matter what order these are in)

#include "Bag_2.hpp"
#include "CharEncoding_2.hpp"
#include "Comparator_2.hpp"
#include "EnvironmentSupport_2.hpp"
#include "From_2.hpp"
#include "Handle_2.hpp"
#include "Heaps_2.hpp"
#include "LoadableSupport_2.hpp"
#include "Map_2.hpp"
#include "ModuleDescriptorSupport_2.hpp"
#include "Multiple_2.hpp"
#include "ObjectLoader_2.hpp"
#include "Pair_2.hpp"
#include "RtsGlobals_2.hpp"
#include "Sequence_2.hpp"
#include "Set_2.hpp"
#include "Storable_2.hpp"
#include "StorageStream_2.hpp"
#include "StreamClasses_2.hpp"
#include "TemplateTypeMatcher_2.hpp"
#include "TypeInfoSupport_2.hpp"
#include "Vectors_2.hpp"

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
