" ***********************************************************************
" File:          perfect.vim
" Author:        Dominic Matthews, for Escher Technologies Ltd.
" Description:   Syntax file to support the 'Perfect' language under vim
" Last Modified: 5th November 2004
" ***********************************************************************

" *******************************************
" Remove any old syntax stuff hanging around
" *******************************************

syn clear

" ***********************************
" A bunch of useful Perfect keywords
" ***********************************

syn keyword	perfectStatement	assert let fi if trace
syn keyword	perfectDirective	axiom proof import
syn keyword	perfectDeclaration	build heap function operator schema selector tag var const property
syn keyword	perfectModifier		associative commutative idempotent identity deferred define early final ghost nonmember limited redefine storable opaque out repeated from
syn keyword	perfectExpression	any exists for self super those that ref then like in on over of forall highest lowest within yield
syn keyword	perfectCast		as is
syn keyword	perfectBuiltinBasic	anything bool char float int real void
syn keyword	perfectBuiltinCollection bag map pair triple seq set
syn keyword	perfectBuiltinValue	false true null pass
syn keyword	perfectPostcond		change satisfy after it
syn keyword	perfectMisc		loop via value result until keep abstract class confined interface internal decrease
syn keyword	perfectMisc		done when enum end exempt public external inherits name post pragma pre invariant
syn keyword	perfectMisc		absurd begin catch goto has par rank require supports throw total try

"syn cluster	perfectKeywords		contains=perfectStatement,perfectDirective,perfectDeclaration,perfectModifier,perfectExpression,perfectCast,perfectBuiltinBasic,perfectBuiltinCollection,perfectBuiltinValue,perfectPostcond,perfectMisc

syn keyword	perfectTodo		contained TODO FIXME XXX


" **********************************************************************
" Don't know if we need this stuff ...
" **********************************************************************

" perfectCommentGroup allows adding matches for special things in comments
syn cluster	perfectCommentGroup	contains=perfectTodo

" when wanted, highlight trailing white space
if exists("c_space_errors")
  if !exists("c_no_trail_space_error")
    syn match	perfectSpaceError	excludenl "\s\+$"
  endif
  if !exists("c_no_tab_space_error")
    syn match	perfectSpaceError	" \+\t"me=e-1
  endif
endif


" ************************************************************************
" String and Character constants ...
" highlight special characters (those which have a backslash) differently
" ************************************************************************

syn match	cSpecial	contained "\\\(x\x\+\|\o\{1,3}\|.\|$\)"
if !exists("c_no_utf")
  syn match	cSpecial	contained "\\\(u\x\{4}\|U\x\{8}\)"
endif
if exists("c_no_cformat")
  syn region	cString		start=+L\="+ skip=+\\\\\|\\"+ end=+"+ contains=cSpecial
  " cCppString: same as cString, but ends at end of line
  syn region	cCppString	start=+L\="+ skip=+\\\\\|\\"\|\\$+ excludenl end=+"+ end='$' contains=cSpecial
else
  syn match	cFormat		"%\(\d\+\$\)\=[-+' #0*]*\(\d*\|\*\|\*\d\+\$\)\(\.\(\d*\|\*\|\*\d\+\$\)\)\=\([hlL]\|ll\)\=\([diuoxXfeEgGcCsSpn]\|\[\^\=.[^]]*\]\)" contained
  syn match	cFormat		"%%" contained
  syn region	cString		start=+L\="+ skip=+\\\\\|\\"+ end=+"+ contains=cSpecial,cFormat
  " cCppString: same as cString, but ends at end of line
  syn region	cCppString	start=+L\="+ skip=+\\\\\|\\"\|\\$+ excludenl end=+"+ end='$' contains=cSpecial,cFormat
  hi link cFormat cSpecial
endif
hi link cCppString cString

" *************
" Comments ...
" *************

syn region	perfectCommentL	start="//" skip="\\$" end="$" keepend contains=@perfectCommentGroup,perfectSpaceError
syn region	perfectComment	start="/\*" end="\*/" contains=@perfectCommentGroup,perfectSpaceError
hi link perfectCommentL perfectComment

" ***************************
" Set up highlight links ...
" ***************************

"if !exists("did_perfect_syntax_inits")
  let did_perfect_syntax_inits = 1

  " link-up the perfect groups ...

  hi link perfectStatement perfectMisc
  hi link perfectDirective perfectMisc
  hi link perfectDeclaration perfectMisc
  hi link perfectModifier perfectMisc
  hi link perfectExpression perfectMisc
  hi link perfectCast perfectMisc
  hi link perfectBuiltinBasic perfectMisc
  hi link perfectBuiltinCollection perfectMisc
  hi link perfectPostcond perfectMisc

  " link-up perfect groups to standard vim highlighting groups ...

  hi link perfectBuiltinValue Constant
  hi link perfectMisc Keyword
  hi link cString String
  hi link perfectComment Comment

  " Set-up some sensible colours (the same as those in Mew32) ...

  hi String guifg=DarkGreen
  hi Keyword guifg=DarkMagenta
  hi Constant guifg=DarkMagenta
  hi Comment guifg=Red
"endif

" *********************************************
" Set up vim for the 'Perfect' environment ...
" *********************************************

let b:current_syntax = "perfect"

set ts=4

" the 'make' program - ie. the Perfect-tool - uses environment variables
set mp=pdtool\ '$PERFECTOPTIONS'\ %
" the error-file-format specifier - don't know how to append onto the existing
" one, so this will now only work with 'Perfect' ...
set efm=%f\ (%l\\,%c)%m
" map <F9> onto the key sequence for compiling a file, to be consistant with
" Mew32 - note that this shortcut will save the buffer before attempting the
" compilation. We create mappings for normal (command) mode and for insert
" mode ...
nmap <F9> :w<CR>:make<CR>
imap <F9> <ESC>:w<CR>:make<CR>i
" map CTRL-l onto the key sequence for listing all errors. Note also that the
" insert mode mapping doesn't leave vim in insert mode since the 'i' command
" will remove the error message listing from the status area! ...
nmap  :cl<CR>
imap  <ESC>:cl<CR>
" map CTRL-n onto the key sequence for moving to the next error - note that the
" insert mode mapping doesn't leave vim in insert mode since the 'i' command
" will remove the error message from the status area! ...
nmap  :cn<CR>
imap  <ESC>:cn<CR>
" map CTRL-p onto the key sequence for moving to the previous error - note that
" the insert mode mapping doesn't leave vim in insert mode since the 'i' comand
" will remove the error message from the status area! ...
nmap  :cp<CR>
imap  <ESC>:cp<CR>

" *****
" End.
" *****
